/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.AbstractUnitFormat;
import tech.units.indriya.format.EBNFHelper;
import tech.units.indriya.format.SymbolMap;
import tech.units.indriya.internal.format.TokenException;
import tech.units.indriya.internal.format.TokenMgrError;
import tech.units.indriya.internal.format.UnitFormatParser;
import tech.units.indriya.unit.AnnotatedUnit;

public class EBNFUnitFormat
extends AbstractUnitFormat {
    private static final String BUNDLE_NAME = "tech.units.indriya.format.messages";
    private static final EBNFUnitFormat DEFAULT_INSTANCE = new EBNFUnitFormat();
    private final transient SymbolMap symbolMap;

    public static EBNFUnitFormat getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static EBNFUnitFormat getInstance(SymbolMap symbols) {
        return new EBNFUnitFormat(symbols);
    }

    EBNFUnitFormat() {
        this(SymbolMap.of(ResourceBundle.getBundle(BUNDLE_NAME, Locale.ROOT)));
    }

    private EBNFUnitFormat(SymbolMap symbols) {
        this.symbolMap = symbols;
    }

    @Override
    protected SymbolMap getSymbols() {
        return this.symbolMap;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Appendable format(Unit<?> unit, Appendable appendable) throws IOException {
        AnnotatedUnit annotatedUnit;
        EBNFHelper.formatInternal(unit, appendable, this.symbolMap);
        if (unit instanceof AnnotatedUnit && (annotatedUnit = (AnnotatedUnit)unit).getAnnotation() != null) {
            appendable.append('{');
            appendable.append(annotatedUnit.getAnnotation());
            appendable.append('}');
        }
        return appendable;
    }

    public Unit<? extends Quantity<?>> parse(CharSequence csq, ParsePosition cursor) throws MeasurementParseException {
        int start = cursor != null ? cursor.getIndex() : 0;
        int end = csq.length();
        if (end <= start) {
            return AbstractUnit.ONE;
        }
        String source = csq.subSequence(start, end).toString().trim();
        if (source.length() == 0) {
            return AbstractUnit.ONE;
        }
        try {
            UnitFormatParser parser = new UnitFormatParser(this.symbolMap, new StringReader(source));
            Unit<?> result = parser.parseUnit();
            if (cursor != null) {
                cursor.setIndex(end);
            }
            return result;
        }
        catch (TokenException e) {
            if (e.currentToken != null) {
                cursor.setErrorIndex(start + e.currentToken.endColumn);
            } else {
                cursor.setErrorIndex(start);
            }
            throw new MeasurementParseException((Throwable)((Object)e));
        }
        catch (TokenMgrError e) {
            cursor.setErrorIndex(start);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    protected Unit<?> parse(CharSequence csq, int index) throws IllegalArgumentException {
        return this.parse(csq, new ParsePosition(index));
    }

    public Unit<?> parse(CharSequence csq) throws MeasurementParseException {
        return this.parse(csq, 0);
    }
}

