/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.quantity.Quantities;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = -6494337491031528402L;
    private final Number value;

    protected NumberQuantity(Number number, Unit<Q> unit, Quantity.Scale sc) {
        super(unit, sc);
        this.value = Calculator.of(number).peek();
    }

    protected NumberQuantity(Number number, Unit<Q> unit) {
        this(number, unit, Quantity.Scale.ABSOLUTE);
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        return this.addition(that, (thisValue, thatValue) -> Calculator.of(thisValue).add((Number)thatValue).peek());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return this.addition(that, (thisValue, thatValue) -> Calculator.of(thisValue).subtract((Number)thatValue).peek());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.multiplication(that, (thisValue, thatValue) -> Calculator.of(thisValue).divide((Number)thatValue).peek(), (thisUnit, thatUnit) -> thisUnit.divide(thatUnit));
    }

    @Override
    public ComparableQuantity<Q> divide(Number divisor) {
        return this.scalarMultiplication(thisValue -> Calculator.of(thisValue).divide(divisor).peek());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.multiplication(that, (thisValue, thatValue) -> Calculator.of(thisValue).multiply((Number)thatValue).peek(), (thisUnit, thatUnit) -> thisUnit.multiply(thatUnit));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number factor) {
        return this.scalarMultiplication(thisValue -> Calculator.of(thisValue).multiply(factor).peek());
    }

    @Override
    public ComparableQuantity<?> inverse() {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).reciprocal().peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit().inverse());
    }

    public Quantity<Q> negate() {
        Number resultValueInThisUnit = Calculator.of(this.getValue()).negate().peek();
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit());
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    private ComparableQuantity<Q> addition(Quantity<Q> that, BinaryOperator<Number> operator) {
        boolean yieldsRelativeScale = Quantity.Scale.RELATIVE.equals((Object)this.getScale()) && Quantity.Scale.RELATIVE.equals((Object)that.getScale());
        AbstractQuantity.ToSystemUnitConverter thisConverter = this.toSystemUnitConverterForAdd(this);
        AbstractQuantity.ToSystemUnitConverter thatConverter = this.toSystemUnitConverterForAdd(that);
        Number thisValueInSystemUnit = thisConverter.apply(this.getValue());
        Number thatValueInSystemUnit = thatConverter.apply(that.getValue());
        Number resultValueInSystemUnit = (Number)operator.apply(thisValueInSystemUnit, thatValueInSystemUnit);
        if (yieldsRelativeScale) {
            return Quantities.getQuantity(thisConverter.invert(resultValueInSystemUnit), this.getUnit(), Quantity.Scale.RELATIVE);
        }
        boolean needsInvering = !thisConverter.isNoop() || !thatConverter.isNoop();
        Number resultValueInThisUnit = needsInvering ? (Number)this.getUnit().getConverterTo(this.getUnit().getSystemUnit()).inverse().convert(resultValueInSystemUnit) : (Number)resultValueInSystemUnit;
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit(), Quantity.Scale.ABSOLUTE);
    }

    private ComparableQuantity<Q> scalarMultiplication(UnaryOperator<Number> operator) {
        if (Quantity.Scale.RELATIVE.equals((Object)this.getScale())) {
            return Quantities.getQuantity((Number)operator.apply(this.getValue()), this.getUnit(), Quantity.Scale.RELATIVE);
        }
        AbstractQuantity.ToSystemUnitConverter thisConverter = NumberQuantity.toSystemUnitConverterForMul(this);
        Number thisValueWithAbsoluteScale = thisConverter.apply(this.getValue());
        Number resultValueInAbsUnits = (Number)operator.apply(thisValueWithAbsoluteScale);
        boolean needsInvering = !thisConverter.isNoop();
        Number resultValueInThisUnit = needsInvering ? (Number)this.getUnit().getConverterTo(this.getUnit().getSystemUnit()).inverse().convert(resultValueInAbsUnits) : (Number)resultValueInAbsUnits;
        return Quantities.getQuantity(resultValueInThisUnit, this.getUnit(), this.getScale());
    }

    private ComparableQuantity<?> multiplication(Quantity<?> that, BinaryOperator<Number> amountOperator, BinaryOperator<Unit<?>> unitOperator) {
        AbstractQuantity.ToSystemUnitConverter thisConverter = NumberQuantity.toSystemUnitConverterForMul(this);
        AbstractQuantity.ToSystemUnitConverter thatConverter = NumberQuantity.toSystemUnitConverterForMul(that);
        Number thisValueWithAbsoluteScale = thisConverter.apply(this.getValue());
        Number thatValueWithAbsoluteScale = thatConverter.apply(that.getValue());
        Number resultValueInSystemUnits = (Number)amountOperator.apply(thisValueWithAbsoluteScale, thatValueWithAbsoluteScale);
        Unit thisAbsUnit = thisConverter.isNoop() ? this.getUnit() : this.getUnit().getSystemUnit();
        Unit thatAbsUnit = thatConverter.isNoop() ? that.getUnit() : that.getUnit().getSystemUnit();
        return Quantities.getQuantity(resultValueInSystemUnits, (Unit)unitOperator.apply(thisAbsUnit, thatAbsUnit));
    }

    private AbstractQuantity.ToSystemUnitConverter toSystemUnitConverterForAdd(Quantity<Q> quantity) {
        Unit systemUnit = this.getUnit().getSystemUnit();
        return AbstractQuantity.ToSystemUnitConverter.forQuantity(quantity, systemUnit);
    }

    private static <T extends Quantity<T>> AbstractQuantity.ToSystemUnitConverter toSystemUnitConverterForMul(Quantity<T> quantity) {
        Unit systemUnit = quantity.getUnit().getSystemUnit();
        return AbstractQuantity.ToSystemUnitConverter.forQuantity(quantity, systemUnit);
    }
}

