/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Dimensionless;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.internal.function.Calculator;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.spi.NumberSystem;
import tech.uom.lib.common.function.UnitSupplier;
import tech.uom.lib.common.function.ValueSupplier;

public abstract class AbstractQuantity<Q extends Quantity<Q>>
implements ComparableQuantity<Q>,
UnitSupplier<Q>,
ValueSupplier<Number> {
    private static final long serialVersionUID = 293852425369811882L;
    private final Unit<Q> unit;
    private final Quantity.Scale scale;
    public static final Quantity<Dimensionless> NONE = Quantities.getQuantity(0, AbstractUnit.ONE);
    public static final Quantity<Dimensionless> ONE = Quantities.getQuantity(1, AbstractUnit.ONE);

    protected AbstractQuantity(Unit<Q> unit, Quantity.Scale sca) {
        this.unit = unit;
        this.scale = sca;
    }

    protected AbstractQuantity(Unit<Q> unit) {
        this(unit, Quantity.Scale.ABSOLUTE);
    }

    public abstract Number getValue();

    public Unit<Q> getUnit() {
        return this.unit;
    }

    public Quantity.Scale getScale() {
        return this.scale;
    }

    @Override
    public ComparableQuantity<Q> to(Unit<Q> anotherUnit) {
        if (anotherUnit.equals(this.getUnit())) {
            return this;
        }
        if (Quantity.Scale.RELATIVE.equals((Object)this.getScale())) {
            Unit systemUnit = this.getUnit().getSystemUnit();
            ToSystemUnitConverter converter = ToSystemUnitConverter.forQuantity(this, systemUnit);
            Number valueInSystemUnit = converter.apply(this.getValue());
            Number valueInOtherUnit = systemUnit.getConverterTo(anotherUnit).convert(valueInSystemUnit);
            return Quantities.getQuantity(valueInOtherUnit, anotherUnit);
        }
        UnitConverter t = this.getUnit().getConverterTo(anotherUnit);
        Number convertedValue = t.convert(this.getValue());
        return Quantities.getQuantity(convertedValue, anotherUnit);
    }

    @Override
    public boolean isGreaterThan(Quantity<Q> that) {
        return this.compareTo(that) > 0;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) >= 0;
    }

    @Override
    public boolean isLessThan(Quantity<Q> that) {
        return this.compareTo(that) < 0;
    }

    @Override
    public boolean isLessThanOrEqualTo(Quantity<Q> that) {
        return this.compareTo(that) <= 0;
    }

    @Override
    public boolean isEquivalentTo(Quantity<Q> that) {
        return this.compareTo(that) == 0;
    }

    @Override
    public int compareTo(Quantity<Q> that) {
        if (this.getUnit().equals((Object)that.getUnit())) {
            return this.numberSystem().compare(this.getValue(), that.getValue());
        }
        return this.numberSystem().compare(this.getValue(), that.to(this.getUnit()).getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && Objects.equals(this.getScale(), that.getScale()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getUnit(), this.getScale(), this.getValue());
    }

    public String toString() {
        return SimpleQuantityFormat.getInstance().format(this);
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> divide(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.divide((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>, E extends Quantity<E>> ComparableQuantity<E> multiply(Quantity<T> that, Class<E> asTypeQuantity) {
        return this.multiply((Quantity)Objects.requireNonNull(that)).asType((Class)Objects.requireNonNull(asTypeQuantity));
    }

    @Override
    public <T extends Quantity<T>> ComparableQuantity<T> inverse(Class<T> quantityClass) {
        return this.inverse().asType((Class)quantityClass);
    }

    @Override
    public final <T extends Quantity<T>> ComparableQuantity<T> asType(Class<T> type) throws ClassCastException {
        this.getUnit().asType(type);
        return this;
    }

    public static Quantity<?> parse(CharSequence csq) {
        return SimpleQuantityFormat.getInstance().parse(csq);
    }

    protected boolean hasFraction(double value) {
        return (double)Math.round(value) != value;
    }

    protected boolean hasFraction(BigDecimal value) {
        return value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }

    protected NumberSystem numberSystem() {
        return Calculus.currentNumberSystem();
    }

    protected static class ToSystemUnitConverter
    implements UnaryOperator<Number> {
        private final UnaryOperator<Number> unaryOperator;
        private final UnaryOperator<Number> inverseOperator;

        public static <Q extends Quantity<Q>> ToSystemUnitConverter forQuantity(Quantity<Q> quantity, Unit<Q> systemUnit) {
            if (quantity.getUnit().equals(systemUnit)) {
                return ToSystemUnitConverter.noop();
            }
            UnitConverter converter = quantity.getUnit().getConverterTo(systemUnit);
            if (Quantity.Scale.ABSOLUTE.equals((Object)quantity.getScale())) {
                return ToSystemUnitConverter.of(arg_0 -> ((UnitConverter)converter).convert(arg_0));
            }
            Number linearFactor = ToSystemUnitConverter.linearFactorOf(converter).orElse(null);
            if (linearFactor != null) {
                return ToSystemUnitConverter.factor(linearFactor);
            }
            throw ToSystemUnitConverter.unsupportedConverter(converter, quantity.getUnit());
        }

        public Number invert(Number x) {
            return this.isNoop() ? (Number)x : (Number)((Number)this.inverseOperator.apply(x));
        }

        public static ToSystemUnitConverter of(UnaryOperator<Number> unaryOperator) {
            return new ToSystemUnitConverter(unaryOperator, null);
        }

        public static ToSystemUnitConverter noop() {
            return new ToSystemUnitConverter(null, null);
        }

        public static ToSystemUnitConverter factor(Number factor) {
            return new ToSystemUnitConverter(number -> Calculator.of(number).multiply(factor).peek(), number -> Calculator.of(number).divide(factor).peek());
        }

        private ToSystemUnitConverter(UnaryOperator<Number> unaryOperator, UnaryOperator<Number> inverseOperator) {
            this.unaryOperator = unaryOperator;
            this.inverseOperator = inverseOperator;
        }

        public boolean isNoop() {
            return this.unaryOperator == null;
        }

        @Override
        public Number apply(Number x) {
            return this.isNoop() ? (Number)x : (Number)((Number)this.unaryOperator.apply(x));
        }

        private static Optional<Number> linearFactorOf(UnitConverter converter) {
            return converter instanceof AbstractConverter ? ((AbstractConverter)converter).linearFactor() : Optional.empty();
        }

        private static UnsupportedOperationException unsupportedConverter(UnitConverter converter, Unit<?> unit) {
            return new UnsupportedOperationException(String.format("Scale conversion from RELATIVE to ABSOLUTE for Unit %s having Converter %s is not implemented.", unit, converter));
        }
    }
}

