/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity.time;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Time;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.quantity.time.TimeQuantities;
import tech.units.indriya.unit.Units;

public final class TimeUnitQuantity
extends AbstractQuantity<Time> {
    private static final long serialVersionUID = -5840251813363744230L;
    private static final BigDecimal LONG_MAX_VALUE = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = new BigDecimal(Long.MIN_VALUE);
    private final TimeUnit timeUnit;
    private final Long value;

    TimeUnitQuantity(TimeUnit timeUnit, Long value) {
        super(TimeUnitQuantity.toUnit(timeUnit));
        this.timeUnit = timeUnit;
        this.value = value;
    }

    public static TimeUnitQuantity of(Long number, TimeUnit timeUnit) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number));
    }

    public static TimeUnitQuantity of(Integer number, TimeUnit timeUnit) {
        return new TimeUnitQuantity(Objects.requireNonNull(timeUnit), Objects.requireNonNull(number).longValue());
    }

    @Deprecated
    public static TimeUnitQuantity of(TimeUnit timeUnit, Integer number) {
        return TimeUnitQuantity.of(number, timeUnit);
    }

    public static TimeUnitQuantity of(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TimeUnitQuantity(TimeUnit.SECONDS, seconds.getValue().longValue());
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return TimeUnitQuantity.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TimeUnitQuantity to(TimeUnit aTimeUnit) {
        Quantity time = this.toQuantity().to(TimeUnitQuantity.toUnit(aTimeUnit));
        return new TimeUnitQuantity(aTimeUnit, time.getValue().longValue());
    }

    private static Unit<Time> toUnit(TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECONDS: {
                return TimeQuantities.MICROSECOND;
            }
            case MILLISECONDS: {
                return TimeQuantities.MILLISECOND;
            }
            case NANOSECONDS: {
                return TimeQuantities.NANOSECOND;
            }
            case SECONDS: {
                return Units.SECOND;
            }
            case MINUTES: {
                return Units.MINUTE;
            }
            case HOURS: {
                return Units.HOUR;
            }
            case DAYS: {
                return Units.DAY;
            }
        }
        throw new IllegalStateException("In TimeUnitQuantity just supports DAYS, HOURS, MICROSECONDS, MILLISECONDS, MINUTES, NANOSECONDS, SECONDS ");
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.timeUnit, this.value});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TimeUnitQuantity.class.isInstance(obj)) {
            TimeUnitQuantity other = (TimeUnitQuantity)TimeUnitQuantity.class.cast(obj);
            return Objects.equals((Object)this.timeUnit, (Object)other.timeUnit) && Objects.equals(this.value, other.value);
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Time unit:" + (Object)((Object)this.timeUnit) + " value: " + this.value;
    }

    private static BigDecimal numberAsBigDecimal(Number that) {
        if (that instanceof BigDecimal) {
            return (BigDecimal)that;
        }
        if (that instanceof BigInteger) {
            return new BigDecimal((BigInteger)that);
        }
        if (that instanceof Double || that instanceof Float) {
            return new BigDecimal(that.doubleValue());
        }
        return new BigDecimal(that.longValue());
    }

    boolean isOverflowing(BigDecimal aValue) {
        return aValue.compareTo(LONG_MIN_VALUE) < 0 || aValue.compareTo(LONG_MAX_VALUE) > 0;
    }

    private static <R extends Quantity<R>> BigDecimal quantityValueAsBigDecimal(Quantity<R> that) {
        return TimeUnitQuantity.convertedQuantityValueAsBigDecimal(that, that.getUnit());
    }

    private static <R extends Quantity<R>> BigDecimal convertedQuantityValueAsBigDecimal(Quantity<R> that, Unit<R> unit) {
        return (BigDecimal)that.getUnit().getConverterTo(unit).convert((Number)TimeUnitQuantity.numberAsBigDecimal(that.getValue()));
    }

    @Override
    public ComparableQuantity<Time> add(Quantity<Time> that) {
        BigDecimal thisValueInSystemUnit = TimeUnitQuantity.convertedQuantityValueAsBigDecimal(this, Units.SECOND);
        BigDecimal thatValueInSystemUnit = TimeUnitQuantity.convertedQuantityValueAsBigDecimal(that, Units.SECOND);
        BigDecimal resultValueInSystemUnit = thisValueInSystemUnit.add(thatValueInSystemUnit, Calculus.MATH_CONTEXT);
        BigDecimal resultValueInThisUnit = TimeUnitQuantity.numberAsBigDecimal(Units.SECOND.getConverterTo(this.getUnit()).convert((Number)resultValueInSystemUnit));
        BigDecimal resultValueInThatUnit = TimeUnitQuantity.numberAsBigDecimal(Units.SECOND.getConverterTo(that.getUnit()).convert((Number)resultValueInSystemUnit));
        TimeUnitQuantity resultInThisUnit = TimeQuantities.getQuantity((Long)resultValueInThisUnit.longValue(), this.timeUnit);
        ComparableQuantity<Time> resultInThatUnit = Quantities.getQuantity(resultValueInThatUnit.longValue(), that.getUnit());
        if (this.isOverflowing(resultValueInThisUnit)) {
            if (this.isOverflowing(resultValueInThatUnit)) {
                throw new ArithmeticException();
            }
            return resultInThatUnit;
        }
        if (this.isOverflowing(resultValueInThatUnit)) {
            return resultInThisUnit;
        }
        if (this.hasFraction(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Time> subtract(Quantity<Time> that) {
        return this.add(that.negate());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, BigDecimal::divide, Unit::divide);
    }

    @Override
    public ComparableQuantity<Time> divide(Number that) {
        return this.applyMultiplicativeNumberOperation(that, BigDecimal::divide);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, BigDecimal::multiply, Unit::multiply);
    }

    @Override
    public ComparableQuantity<Time> multiply(Number that) {
        return this.applyMultiplicativeNumberOperation(that, BigDecimal::multiply);
    }

    private ComparableQuantity<?> applyMultiplicativeQuantityOperation(Quantity<?> that, TriFunction<BigDecimal, BigDecimal, BigDecimal, MathContext> valueOperator, BiFunction<Unit<?>, Unit<?>, Unit<?>> unitOperator) {
        BigDecimal thatValue;
        BigDecimal thisValue = TimeUnitQuantity.quantityValueAsBigDecimal(this);
        BigDecimal result = valueOperator.apply(thisValue, thatValue = TimeUnitQuantity.quantityValueAsBigDecimal(that), Calculus.MATH_CONTEXT);
        if (this.isOverflowing(result)) {
            throw new ArithmeticException();
        }
        Unit<?> resultUnit = unitOperator.apply(this.getUnit(), that.getUnit());
        return Quantities.getQuantity(result.longValue(), resultUnit);
    }

    private ComparableQuantity<Time> applyMultiplicativeNumberOperation(Number that, TriFunction<BigDecimal, BigDecimal, BigDecimal, MathContext> valueOperator) {
        BigDecimal thatValue;
        BigDecimal thisValue = TimeUnitQuantity.numberAsBigDecimal(this.value);
        BigDecimal result = valueOperator.apply(thisValue, thatValue = TimeUnitQuantity.numberAsBigDecimal(that), Calculus.MATH_CONTEXT);
        if (this.isOverflowing(result)) {
            throw new ArithmeticException();
        }
        return Quantities.getQuantity(result.longValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Frequency> inverse() {
        return Quantities.getQuantity(1.0 / (double)this.value.longValue(), TimeUnitQuantity.toUnit(this.timeUnit).inverse()).asType(Frequency.class);
    }

    @Override
    public boolean isBig() {
        return false;
    }

    public Quantity<Time> negate() {
        return TimeUnitQuantity.of(-this.value.longValue(), this.getTimeUnit());
    }

    @FunctionalInterface
    private static interface TriFunction<R, A, B, C> {
        public R apply(A var1, B var2, C var3);
    }
}

