/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity.time;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Time;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.quantity.time.TimeQuantities;
import tech.units.indriya.unit.Units;

public final class TemporalQuantity
extends AbstractQuantity<Time> {
    private static final long serialVersionUID = 6835738653744691425L;
    private static final BigDecimal LONG_MAX_VALUE = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = new BigDecimal(Long.MIN_VALUE);
    private final TemporalUnit timeUnit;
    private final Long value;
    private final TemporalAmount amount;

    TemporalQuantity(Long value, TemporalUnit timeUnit) {
        super(TemporalQuantity.toUnit(timeUnit));
        this.timeUnit = timeUnit;
        this.amount = Duration.of(value, timeUnit);
        this.value = value;
    }

    public static TemporalQuantity of(Long number, TemporalUnit timeUnit) {
        return new TemporalQuantity(Objects.requireNonNull(number), Objects.requireNonNull(timeUnit));
    }

    public static TemporalQuantity of(Integer number, TemporalUnit timeUnit) {
        return new TemporalQuantity(Objects.requireNonNull(number).longValue(), Objects.requireNonNull(timeUnit));
    }

    public static TemporalQuantity of(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TemporalQuantity(seconds.getValue().longValue(), ChronoUnit.SECONDS);
    }

    public TemporalAmount getTemporalAmount() {
        return this.amount;
    }

    public TemporalUnit getTemporalUnit() {
        return this.timeUnit;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return TemporalQuantity.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TemporalQuantity to(TemporalUnit aTimeUnit) {
        Quantity time = this.toQuantity().to(TemporalQuantity.toUnit(aTimeUnit));
        return new TemporalQuantity(time.getValue().longValue(), aTimeUnit);
    }

    private static Unit<Time> toUnit(TemporalUnit timeUnit) {
        if (timeUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)timeUnit;
            switch (chronoUnit) {
                case MICROS: {
                    return TimeQuantities.MICROSECOND;
                }
                case MILLIS: {
                    return TimeQuantities.MILLISECOND;
                }
                case NANOS: {
                    return TimeQuantities.NANOSECOND;
                }
                case SECONDS: {
                    return Units.SECOND;
                }
                case MINUTES: {
                    return Units.MINUTE;
                }
                case HOURS: {
                    return Units.HOUR;
                }
                case DAYS: {
                    return Units.DAY;
                }
            }
            throw new IllegalArgumentException("TemporalQuantity only supports DAYS, HOURS, MICROS, MILLIS, MINUTES, NANOS, SECONDS ");
        }
        throw new IllegalArgumentException("TemporalQuantity only supports temporal units of type ChronoUnit");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timeUnit, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TemporalQuantity.class.isInstance(obj)) {
            TemporalQuantity other = (TemporalQuantity)TemporalQuantity.class.cast(obj);
            return Objects.equals(this.timeUnit, other.timeUnit) && Objects.equals(this.value, other.value);
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Temporal unit:" + this.timeUnit + " value: " + this.value;
    }

    private static BigDecimal numberAsBigDecimal(Number that) {
        if (that instanceof BigDecimal) {
            return (BigDecimal)that;
        }
        if (that instanceof BigInteger) {
            return new BigDecimal((BigInteger)that);
        }
        if (that instanceof Double || that instanceof Float) {
            return new BigDecimal(that.doubleValue());
        }
        return new BigDecimal(that.longValue());
    }

    boolean isOverflowing(BigDecimal aValue) {
        return aValue.compareTo(LONG_MIN_VALUE) < 0 || aValue.compareTo(LONG_MAX_VALUE) > 0;
    }

    private static <R extends Quantity<R>> BigDecimal quantityValueAsBigDecimal(Quantity<R> that) {
        return TemporalQuantity.convertedQuantityValueAsBigDecimal(that, that.getUnit());
    }

    private static <R extends Quantity<R>> BigDecimal convertedQuantityValueAsBigDecimal(Quantity<R> that, Unit<R> unit) {
        return (BigDecimal)that.getUnit().getConverterTo(unit).convert((Number)TemporalQuantity.numberAsBigDecimal(that.getValue()));
    }

    @Override
    public ComparableQuantity<Time> add(Quantity<Time> that) {
        BigDecimal thisValueInSystemUnit = TemporalQuantity.convertedQuantityValueAsBigDecimal(this, Units.SECOND);
        BigDecimal thatValueInSystemUnit = TemporalQuantity.convertedQuantityValueAsBigDecimal(that, Units.SECOND);
        BigDecimal resultValueInSystemUnit = thisValueInSystemUnit.add(thatValueInSystemUnit, Calculus.MATH_CONTEXT);
        BigDecimal resultValueInThisUnit = TemporalQuantity.numberAsBigDecimal(Units.SECOND.getConverterTo(this.getUnit()).convert((Number)resultValueInSystemUnit));
        BigDecimal resultValueInThatUnit = TemporalQuantity.numberAsBigDecimal(Units.SECOND.getConverterTo(that.getUnit()).convert((Number)resultValueInSystemUnit));
        TemporalQuantity resultInThisUnit = TimeQuantities.getQuantity((Long)resultValueInThisUnit.longValue(), this.timeUnit);
        ComparableQuantity<Time> resultInThatUnit = Quantities.getQuantity(resultValueInThatUnit.longValue(), that.getUnit());
        if (this.isOverflowing(resultValueInThisUnit)) {
            if (this.isOverflowing(resultValueInThatUnit)) {
                throw new ArithmeticException();
            }
            return resultInThatUnit;
        }
        if (this.isOverflowing(resultValueInThatUnit)) {
            return resultInThisUnit;
        }
        if (this.hasFraction(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Time> subtract(Quantity<Time> that) {
        return this.add(that.negate());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, BigDecimal::divide, Unit::divide);
    }

    @Override
    public ComparableQuantity<Time> divide(Number that) {
        return this.applyMultiplicativeNumberOperation(that, BigDecimal::divide);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, BigDecimal::multiply, Unit::multiply);
    }

    @Override
    public ComparableQuantity<Time> multiply(Number that) {
        return this.applyMultiplicativeNumberOperation(that, BigDecimal::multiply);
    }

    private ComparableQuantity<?> applyMultiplicativeQuantityOperation(Quantity<?> that, TriFunction<BigDecimal, BigDecimal, BigDecimal, MathContext> valueOperator, BiFunction<Unit<?>, Unit<?>, Unit<?>> unitOperator) {
        BigDecimal thatValue;
        BigDecimal thisValue = TemporalQuantity.quantityValueAsBigDecimal(this);
        BigDecimal result = valueOperator.apply(thisValue, thatValue = TemporalQuantity.quantityValueAsBigDecimal(that), Calculus.MATH_CONTEXT);
        if (this.isOverflowing(result)) {
            throw new ArithmeticException();
        }
        Unit<?> resultUnit = unitOperator.apply(this.getUnit(), that.getUnit());
        return Quantities.getQuantity(result.longValue(), resultUnit);
    }

    private ComparableQuantity<Time> applyMultiplicativeNumberOperation(Number that, TriFunction<BigDecimal, BigDecimal, BigDecimal, MathContext> valueOperator) {
        BigDecimal thatValue;
        BigDecimal thisValue = TemporalQuantity.numberAsBigDecimal(this.getValue());
        BigDecimal result = valueOperator.apply(thisValue, thatValue = TemporalQuantity.numberAsBigDecimal(that), Calculus.MATH_CONTEXT);
        if (this.isOverflowing(result)) {
            throw new ArithmeticException();
        }
        return Quantities.getQuantity(result.longValue(), this.getUnit());
    }

    @Override
    public ComparableQuantity<Frequency> inverse() {
        return Quantities.getQuantity(1.0 / this.value.doubleValue(), TemporalQuantity.toUnit(this.timeUnit).inverse()).asType(Frequency.class);
    }

    @Override
    public boolean isBig() {
        return false;
    }

    public Quantity<Time> negate() {
        return TemporalQuantity.of(-this.value.longValue(), this.getTemporalUnit());
    }

    @FunctionalInterface
    private static interface TriFunction<R, A, B, C> {
        public R apply(A var1, B var2, C var3);
    }
}

