/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.format.QuantityFormat;
import javax.measure.spi.FormatService;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.NumberDelimiterQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.internal.format.DefaultUnitFormatService;

public class DefaultFormatService
extends DefaultUnitFormatService
implements FormatService {
    static final int PRIO = 1000;
    private static final String DEFAULT_FORMAT_NAME = "Simple";
    private static final NumberDelimiterQuantityFormat EBNF_QUANTITY_FORMAT = new NumberDelimiterQuantityFormat.Builder().setNumberFormat(NumberFormat.getInstance(Locale.ROOT)).setUnitFormat(EBNFUnitFormat.getInstance()).build();
    private final Map<String, QuantityFormat> quantityFormats = new HashMap<String, QuantityFormat>();

    public DefaultFormatService() {
        this.quantityFormats.put(DEFAULT_FORMAT_NAME, SimpleQuantityFormat.getInstance());
        this.quantityFormats.put("NumberDelimiter", NumberDelimiterQuantityFormat.getInstance());
        this.quantityFormats.put("EBNF", EBNF_QUANTITY_FORMAT);
        this.quantityFormats.put("Local", NumberDelimiterQuantityFormat.getInstance(FormatBehavior.LOCALE_SENSITIVE));
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public QuantityFormat getQuantityFormat(String name) {
        return this.quantityFormats.get(name);
    }

    public QuantityFormat getQuantityFormat() {
        return this.getQuantityFormat(DEFAULT_FORMAT_NAME);
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        switch (type) {
            case QUANTITY_FORMAT: {
                return this.quantityFormats.keySet();
            }
        }
        return this.unitFormats.keySet();
    }
}

