/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import java.util.logging.Logger;
import tech.units.indriya.function.NumberSystem;
import tech.units.indriya.internal.function.calc.DefaultNumberSystem;

public final class Calculus {
    private static final String MSG_NUMBER_NON_NULL = "number cannot be null";
    private static final Logger logger = Logger.getLogger(Calculus.class.getName());
    public static final MathContext DEFAULT_MATH_CONTEXT;
    public static MathContext MATH_CONTEXT;
    public static final NumberSystem DEFAULT_NUMBER_SYSTEM;
    public static NumberSystem NUMBER_SYSTEM;
    private static final double upperBoundForLong = 9.223372036854776E18;
    private static final double lowerBoundForLong = -9.223372036854776E18;

    public static boolean isPrimitiveNonFractional(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        return number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte;
    }

    public static boolean isNonFractional(Number number) {
        return Calculus.isPrimitiveNonFractional(number) || number instanceof BigInteger;
    }

    public static void assertNotFractional(Number number) {
        if (!Calculus.isNonFractional(number)) {
            throw new ArithmeticException("number is fractional");
        }
    }

    public static void assertNotNegative(Number number) {
        if (Calculus.isLessThanZero(number)) {
            throw new ArithmeticException("number is fractional");
        }
    }

    @Deprecated
    public static BigDecimal toBigDecimal(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Double || number instanceof Float) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return BigDecimal.valueOf(number.doubleValue());
    }

    @Deprecated
    public static BigInteger toBigInteger(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            try {
                return ((BigDecimal)number).toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                logger.fine(() -> String.format("WARNING: loosing precision, when converting from BigDecimal to BigInteger.", number.getClass().getName()));
                return ((BigDecimal)number).toBigInteger();
            }
        }
        if (number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return BigInteger.valueOf(number.longValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to long.", number.getClass().getName()));
        return BigInteger.valueOf(number.longValue());
    }

    @Deprecated
    public static Number abs(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).abs();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).abs();
        }
        if (number instanceof Double) {
            return Math.abs((Double)number);
        }
        if (number instanceof Long) {
            return Math.abs((Long)number);
        }
        if (number instanceof Integer) {
            return Math.abs((Integer)number);
        }
        if (number instanceof Short) {
            return Math.abs(((Short)number).shortValue());
        }
        if (number instanceof Byte) {
            return Math.abs(((Byte)number).byteValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return Math.abs(number.doubleValue());
    }

    @Deprecated
    public static Number negate(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).negate();
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).negate();
        }
        if (number instanceof Double) {
            return -((Double)number).doubleValue();
        }
        if (number instanceof Long) {
            return -((Long)number).longValue();
        }
        if (number instanceof Integer) {
            return -((Integer)number).intValue();
        }
        if (number instanceof Short) {
            return (int)(-((Short)number).shortValue());
        }
        if (number instanceof Byte) {
            return (int)(-((Byte)number).byteValue());
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return -number.doubleValue();
    }

    @Deprecated
    public static boolean isLessThanOne(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).compareTo(BigInteger.ONE) < 0;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).compareTo(BigDecimal.ONE) < 0;
        }
        if (number instanceof Double) {
            return (Double)number < 1.0;
        }
        if (Calculus.isPrimitiveNonFractional(number)) {
            return number.longValue() < 1L;
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return number.doubleValue() < 1.0;
    }

    @Deprecated
    public static boolean isLessThanZero(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).compareTo(BigInteger.ZERO) < 0;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).compareTo(BigDecimal.ZERO) < 0;
        }
        if (number instanceof Double) {
            return (Double)number < 0.0;
        }
        if (Calculus.isPrimitiveNonFractional(number)) {
            return number.longValue() < 0L;
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return number.doubleValue() < 0.0;
    }

    public static int bitLength(Number number) {
        if (number == null) {
            return -1;
        }
        if (Calculus.isPrimitiveNonFractional(number)) {
            long long_value = number.longValue();
            if (long_value == Long.MIN_VALUE) {
                return 63;
            }
            return Long.bitCount(Math.abs(long_value));
        }
        if (number instanceof BigInteger) {
            return ((BigInteger)number).bitLength();
        }
        return -1;
    }

    public static int intValueExact(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).intValueExact();
        }
        if (Calculus.isPrimitiveNonFractional(number)) {
            long long_value = number.longValue();
            return Math.toIntExact(long_value);
        }
        throw new ArithmeticException("Number out of int range");
    }

    public static long longValueExact(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger) {
            return ((BigInteger)number).longValueExact();
        }
        if (Calculus.isPrimitiveNonFractional(number)) {
            return number.longValue();
        }
        throw new ArithmeticException("Number out of long range");
    }

    public static Number longValueIfExact(Number number) {
        if (number == null) {
            return null;
        }
        int total_bits_required = Calculus.bitLength(number);
        if (total_bits_required < 63) {
            return Calculus.longValueExact(number);
        }
        return number;
    }

    public static Number multiply(Number x, Number y) {
        if (Calculus.isNonFractional(x) && Calculus.isNonFractional(y)) {
            int total_bits_required = Calculus.bitLength(x) + Calculus.bitLength(y);
            if (total_bits_required < 31) {
                return Calculus.intValueExact(x) * Calculus.intValueExact(y);
            }
            if (total_bits_required < 63) {
                return Calculus.longValueExact(x) * Calculus.longValueExact(y);
            }
            return Calculus.toBigInteger(x).multiply(Calculus.toBigInteger(y));
        }
        return Calculus.toBigDecimal(x).multiply(Calculus.toBigDecimal(y));
    }

    public static Number add(Number x, Number y) {
        if (Calculus.isNonFractional(x) && Calculus.isNonFractional(y)) {
            int total_bits_required = Math.max(Calculus.bitLength(x), Calculus.bitLength(y)) + 1;
            if (total_bits_required < 31) {
                return Calculus.intValueExact(x) + Calculus.intValueExact(y);
            }
            if (total_bits_required < 63) {
                return Calculus.longValueExact(x) + Calculus.longValueExact(y);
            }
            return Calculus.toBigInteger(x).add(Calculus.toBigInteger(y));
        }
        return Calculus.toBigDecimal(x).add(Calculus.toBigDecimal(y));
    }

    public static boolean canBeRoundedToLong(double x) {
        return -9.223372036854776E18 < x && x < 9.223372036854776E18;
    }

    public static Number toLongIfCanBeRoundedToLong(double x) {
        return Calculus.canBeRoundedToLong(x) ? (double)((long)x) : x;
    }

    public static Number roundTowardsZero(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger || number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return number;
        }
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).toBigInteger();
        }
        if (number instanceof Double) {
            return Calculus.roundTowardsZero((Double)number);
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return Calculus.roundTowardsZero(number.doubleValue());
    }

    private static final double roundTowardsZero(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return value;
        }
        return value < 0.0 ? Math.ceil(value) : Math.floor(value);
    }

    public static IntegerAndFraction roundTowardsZeroWithRemainder(Number number) {
        Objects.requireNonNull(number, MSG_NUMBER_NON_NULL);
        if (number instanceof BigInteger || number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte) {
            return new IntegerAndFraction(number, null);
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDec = (BigDecimal)number;
            BigInteger integer = bigDec.toBigInteger();
            BigDecimal fraction = bigDec.subtract(new BigDecimal(integer), MATH_CONTEXT);
            return new IntegerAndFraction(integer, fraction);
        }
        if (number instanceof Double) {
            return Calculus.roundTowardsZeroWithRemainder((Double)number);
        }
        logger.fine(() -> String.format("WARNING: possibly loosing precision, when converting from Number type '%s' to double.", number.getClass().getName()));
        return Calculus.roundTowardsZeroWithRemainder(number.doubleValue());
    }

    private static final IntegerAndFraction roundTowardsZeroWithRemainder(double value) {
        double integer = Calculus.roundTowardsZero(value);
        double fraction = value - integer;
        return new IntegerAndFraction(Calculus.toLongIfCanBeRoundedToLong(integer), fraction);
    }

    static {
        MATH_CONTEXT = DEFAULT_MATH_CONTEXT = MathContext.DECIMAL128;
        NUMBER_SYSTEM = DEFAULT_NUMBER_SYSTEM = new DefaultNumberSystem();
    }

    public static class IntegerAndFraction {
        private final Number integer;
        private final Number fraction;

        public IntegerAndFraction(Number integer, Number fraction) {
            this.integer = integer;
            this.fraction = fraction;
        }

        public Number getInteger() {
            return this.integer;
        }

        public Number getFraction() {
            return this.fraction;
        }
    }
}

