/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import java.util.Map;
import java.util.Objects;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractUnit;
import tech.uom.lib.common.function.UnitConverterSupplier;

public final class TransformedUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q>
implements UnitConverterSupplier {
    private static final long serialVersionUID = 1L;
    private final AbstractUnit<Q> parentUnit;
    private final Unit<Q> systemUnit;
    private final UnitConverter converter;
    private String symbol;

    public TransformedUnit(Unit<Q> parentUnit, UnitConverter unitConverter) {
        this(null, parentUnit, unitConverter);
    }

    public TransformedUnit(String symbol, Unit<Q> parentUnit, UnitConverter unitConverter) {
        this(symbol, parentUnit, parentUnit.getSystemUnit(), unitConverter);
    }

    public TransformedUnit(String symbol, Unit<Q> parentUnit, Unit<Q> sysUnit, UnitConverter unitConverter) {
        if (!(parentUnit instanceof AbstractUnit)) {
            throw new IllegalArgumentException("The parent unit: " + parentUnit + " is not an abstract unit.");
        }
        AbstractUnit abParent = (AbstractUnit)parentUnit;
        this.systemUnit = sysUnit;
        this.parentUnit = abParent;
        this.converter = unitConverter;
        this.symbol = symbol;
    }

    @Override
    public Dimension getDimension() {
        return this.parentUnit.getDimension();
    }

    @Override
    public UnitConverter getSystemConverter() {
        return this.parentUnit.getSystemConverter().concatenate(this.converter);
    }

    public UnitConverter getConverter() {
        return this.converter;
    }

    @Override
    protected Unit<Q> toSystemUnit() {
        return this.systemUnit != null ? this.systemUnit : this.parentUnit.getSystemUnit();
    }

    @Override
    public Map<? extends Unit<?>, Integer> getBaseUnits() {
        return this.parentUnit.getBaseUnits();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentUnit, this.converter);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformedUnit) {
            TransformedUnit other = (TransformedUnit)obj;
            return Objects.equals(this.parentUnit, other.parentUnit) && Objects.equals(this.converter, other.converter);
        }
        if (obj instanceof AbstractUnit) {
            return AbstractUnit.Equalizer.areEqual(this, (AbstractUnit)obj);
        }
        return false;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Unit<Q> getParentUnit() {
        return this.parentUnit;
    }
}

