/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.BigIntegerQuantity;
import tech.units.indriya.quantity.ByteQuantity;
import tech.units.indriya.quantity.DecimalQuantity;
import tech.units.indriya.quantity.DoubleQuantity;
import tech.units.indriya.quantity.FloatQuantity;
import tech.units.indriya.quantity.IntegerQuantity;
import tech.units.indriya.quantity.LongQuantity;
import tech.units.indriya.quantity.ShortQuantity;

public class NumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 7312161895652321241L;
    private final Number value;
    private final boolean isBig;

    protected NumberQuantity(Number number, Unit<Q> unit) {
        super(unit);
        this.value = number;
        this.isBig = number instanceof BigDecimal || number instanceof BigInteger;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        UnitConverter converter = this.getUnit().getConverterTo(unit);
        return converter.convert(this.getValue().doubleValue());
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isBig() {
        return this.isBig;
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        return this.toDecimalQuantity().add((Quantity)that);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.toDecimalQuantity().multiply((Quantity)that);
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return this.toDecimalQuantity().multiply(that);
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.toDecimalQuantity().divide((Quantity)that);
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return this.toDecimalQuantity().divide(that);
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return new NumberQuantity<Q>(this.getValue() instanceof BigDecimal ? BigDecimal.ONE.divide((BigDecimal)this.getValue()) : Double.valueOf(1.0 / this.getValue().doubleValue()), this.getUnit().inverse());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) throws ArithmeticException {
        return Calculus.toBigDecimal(this.getUnit().getConverterTo(unit).convert(this.getValue()));
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return this.toDecimalQuantity().subtract((Quantity)that);
    }

    public Quantity<Q> negate() {
        if (BigDecimal.class.isInstance(this.value)) {
            return new DecimalQuantity(((BigDecimal)BigDecimal.class.cast(this.value)).negate(), this.getUnit());
        }
        if (BigInteger.class.isInstance(this.value)) {
            return new DecimalQuantity(new BigDecimal((BigInteger)BigInteger.class.cast(this.value)).negate(), this.getUnit());
        }
        if (Long.class.isInstance(this.value)) {
            return new IntegerQuantity(-this.value.intValue(), this.getUnit());
        }
        if (Integer.class.isInstance(this.value)) {
            return new IntegerQuantity(-this.value.intValue(), this.getUnit());
        }
        if (Float.class.isInstance(this.value)) {
            return new FloatQuantity(-this.value.floatValue(), this.getUnit());
        }
        if (Short.class.isInstance(this.value)) {
            return new ShortQuantity(-this.value.shortValue(), this.getUnit());
        }
        if (Byte.class.isInstance(this.value)) {
            return new ByteQuantity(-this.value.byteValue(), this.getUnit());
        }
        return new DoubleQuantity(-this.value.doubleValue(), this.getUnit());
    }

    private DecimalQuantity<Q> toDecimalQuantity() {
        return new DecimalQuantity(BigDecimal.valueOf(this.value.doubleValue()), this.getUnit());
    }

    static <Q extends Quantity<Q>> AbstractQuantity<Q> of(BigDecimal bigDecimal, Unit<Q> unit) {
        return new DecimalQuantity<Q>(bigDecimal, unit);
    }

    static <Q extends Quantity<Q>> AbstractQuantity<Q> of(BigInteger bigInteger, Unit<Q> unit) {
        return new BigIntegerQuantity<Q>(bigInteger, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(long longValue, Unit<Q> unit) {
        return new LongQuantity<Q>(longValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(int intValue, Unit<Q> unit) {
        return new IntegerQuantity<Q>(intValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(short value, Unit<Q> unit) {
        return new ShortQuantity<Q>(value, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(byte value, Unit<Q> unit) {
        return new ByteQuantity<Q>(value, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(float floatValue, Unit<Q> unit) {
        return new FloatQuantity<Q>(floatValue, unit);
    }

    public static <Q extends Quantity<Q>> AbstractQuantity<Q> of(double doubleValue, Unit<Q> unit) {
        return new DoubleQuantity<Q>(doubleValue, unit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

