/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;

final class LongQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q> {
    private static final long serialVersionUID = 3092808554937634365L;
    private static final BigDecimal LONG_MAX_VALUE = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = new BigDecimal(Long.MIN_VALUE);
    private final long value;

    public LongQuantity(long value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return value.compareTo(LONG_MIN_VALUE) < 0 || value.compareTo(LONG_MAX_VALUE) > 0;
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return new LongQuantity<Q>(1L / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public boolean isDecimal() {
        return false;
    }

    @Override
    public int getSize() {
        return 64;
    }

    @Override
    public Class<?> getNumberType() {
        return Long.TYPE;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return value.longValue();
    }

    public Quantity<Q> negate() {
        return new LongQuantity(-this.value, this.getUnit());
    }
}

