/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.NumberQuantity;

abstract class JavaNumberQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q> {
    private static final long serialVersionUID = -772486200565856789L;
    private static final BigDecimal LONG_MAX_VALUE = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = new BigDecimal(Long.MIN_VALUE);

    protected JavaNumberQuantity(Unit<Q> unit) {
        super(unit);
    }

    abstract boolean isDecimal();

    abstract int getSize();

    abstract Class<?> getNumberType();

    abstract Number castFromBigDecimal(BigDecimal var1);

    abstract boolean isOverflowing(BigDecimal var1);

    @Override
    public double doubleValue(Unit<Q> unit) {
        double result = this.getUnit().getConverterTo(unit).convert(this.getValue()).doubleValue();
        if (Double.isInfinite(result)) {
            throw new ArithmeticException();
        }
        return result;
    }

    @Override
    protected long longValue(Unit<Q> unit) {
        BigDecimal result = (BigDecimal)this.getUnit().getConverterTo(unit).convert((Number)this.numberAsBigDecimal(this.getValue()));
        if (result.compareTo(LONG_MIN_VALUE) < 0 || result.compareTo(LONG_MAX_VALUE) > 0) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return result.longValue();
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) {
        if (this.getUnit().equals(unit)) {
            return this.numberAsBigDecimal(this.getValue());
        }
        return (BigDecimal)this.getUnit().getConverterTo(unit).convert((Number)this.numberAsBigDecimal(this.getValue()));
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        if (this.canWidenTo(that)) {
            return this.widenTo((JavaNumberQuantity)that).add((Quantity)that);
        }
        BigDecimal thisValueInThisUnit = this.decimalValue(this.getUnit());
        BigDecimal thatValueInThisUnit = this.convertedQuantityValueAsBigDecimal(that, this.getUnit());
        BigDecimal thisValueInThatUnit = this.decimalValue(that.getUnit());
        BigDecimal thatValueInThatUnit = this.quantityValueAsBigDecimal(that);
        BigDecimal resultValueInThisUnit = thisValueInThisUnit.add(thatValueInThisUnit, Calculus.MATH_CONTEXT);
        BigDecimal resultValueInThatUnit = thisValueInThatUnit.add(thatValueInThatUnit, Calculus.MATH_CONTEXT);
        ComparableQuantity resultInThisUnit = this.createTypedQuantity(this.getNumberType(), this.castFromBigDecimal(resultValueInThisUnit), this.getUnit());
        ComparableQuantity<Q> resultInThatUnit = this.createTypedQuantity(this.getNumberType(), this.castFromBigDecimal(resultValueInThatUnit), that.getUnit());
        if (this.isOverflowing(resultValueInThisUnit)) {
            if (this.isOverflowing(resultValueInThatUnit)) {
                throw new ArithmeticException();
            }
            return resultInThatUnit;
        }
        if (this.isOverflowing(resultValueInThatUnit)) {
            return resultInThisUnit;
        }
        if (!this.isDecimal() && this.hasFraction(resultValueInThisUnit)) {
            return resultInThatUnit;
        }
        return resultInThisUnit;
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        return this.add(that.negate());
    }

    private ComparableQuantity<?> applyMultiplicativeQuantityOperation(Quantity<?> that, BiFunction<ComparableQuantity<Q>, Quantity<?>, ComparableQuantity<?>> thisOperator, TriFunction<BigDecimal, BigDecimal, BigDecimal, MathContext> valueOperator, BiFunction<Unit<?>, Unit<?>, Unit<?>> unitOperator) {
        BigDecimal thatValue;
        if (this.canWidenTo(that)) {
            return thisOperator.apply(this.widenTo((JavaNumberQuantity)that), that);
        }
        BigDecimal thisValue = this.decimalValue(this.getUnit());
        BigDecimal result = valueOperator.apply(thisValue, thatValue = this.quantityValueAsBigDecimal(that), Calculus.MATH_CONTEXT);
        if (this.isOverflowing(result)) {
            throw new ArithmeticException();
        }
        Unit<?> resultUnit = unitOperator.apply(this.getUnit(), that.getUnit());
        return this.createQuantity(this.getNumberType(), this.castFromBigDecimal(result), resultUnit);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, ComparableQuantity::multiply, BigDecimal::multiply, Unit::multiply);
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, ComparableQuantity::divide, BigDecimal::divide, Unit::divide);
    }

    private ComparableQuantity<Q> applyMultiplicativeNumberOperation(Number that, TriFunction<BigDecimal, BigDecimal, BigDecimal, MathContext> valueOperator) {
        BigDecimal thatValue;
        BigDecimal thisValue = this.decimalValue(this.getUnit());
        BigDecimal result = valueOperator.apply(thisValue, thatValue = this.numberAsBigDecimal(that), Calculus.MATH_CONTEXT);
        if (this.isOverflowing(result)) {
            throw new ArithmeticException();
        }
        return this.createTypedQuantity(this.getNumberType(), this.castFromBigDecimal(result), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return this.applyMultiplicativeNumberOperation(that, BigDecimal::multiply);
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return this.applyMultiplicativeNumberOperation(that, BigDecimal::divide);
    }

    private <R extends Quantity<R>> BigDecimal quantityValueAsBigDecimal(Quantity<R> that) {
        return this.convertedQuantityValueAsBigDecimal(that, that.getUnit());
    }

    private <R extends Quantity<R>> BigDecimal convertedQuantityValueAsBigDecimal(Quantity<R> that, Unit<R> unit) {
        if (that instanceof JavaNumberQuantity) {
            return ((JavaNumberQuantity)that).decimalValue(unit);
        }
        return (BigDecimal)that.getUnit().getConverterTo(unit).convert((Number)this.numberAsBigDecimal(that.getValue()));
    }

    private BigDecimal numberAsBigDecimal(Number that) {
        if (that instanceof BigDecimal) {
            return (BigDecimal)that;
        }
        if (that instanceof BigInteger) {
            return new BigDecimal((BigInteger)that);
        }
        if (that instanceof Double || that instanceof Float) {
            return new BigDecimal(that.doubleValue());
        }
        return new BigDecimal(that.longValue());
    }

    boolean canWidenTo(Quantity<?> target) {
        if (target instanceof JavaNumberQuantity) {
            JavaNumberQuantity jnTarget = (JavaNumberQuantity)target;
            if (jnTarget.isDecimal() && !this.isDecimal()) {
                return true;
            }
            if (this.isDecimal() && !jnTarget.isDecimal()) {
                return false;
            }
            if (jnTarget.isBig() && !this.isBig()) {
                return true;
            }
            return this.getSize() != 0 && jnTarget.getSize() > this.getSize();
        }
        return false;
    }

    ComparableQuantity<Q> widenTo(JavaNumberQuantity<Q> target) {
        return this.createTypedQuantity(target.getNumberType(), this.widenValue(this, target), this.getUnit());
    }

    private ComparableQuantity<?> createQuantity(Class<?> numberType, Number value, Unit<?> unit) {
        try {
            Method m = NumberQuantity.class.getDeclaredMethod("of", numberType, Unit.class);
            return (ComparableQuantity)m.invoke(null, value, unit);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ComparableQuantity<Q> createTypedQuantity(Class<?> numberType, Number value, Unit<Q> unit) {
        return this.createQuantity(numberType, value, unit);
    }

    private Number widenValue(JavaNumberQuantity<Q> source, JavaNumberQuantity<?> target) {
        Number value = source.getValue();
        if (target.isBig() && !source.isBig()) {
            value = target.getNumberType().equals(BigInteger.class) ? BigInteger.valueOf(value.longValue()) : BigDecimal.valueOf(value.doubleValue());
        } else if (source.getNumberType().equals(BigInteger.class) && !target.isBig()) {
            value = target.getNumberType().equals(Float.TYPE) ? (Number)Float.valueOf(source.getValue().floatValue()) : (Number)source.getValue().doubleValue();
        } else if (source.getNumberType().equals(BigInteger.class) && target.getNumberType().equals(BigDecimal.class)) {
            value = new BigDecimal((BigInteger)value);
        }
        return value;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.getValue(), that.getValue());
        }
        return false;
    }

    @FunctionalInterface
    private static interface TriFunction<R, A, B, C> {
        public R apply(A var1, B var2, C var3);
    }
}

