/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;
import tech.units.indriya.quantity.NumberQuantity;

final class IntegerQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q> {
    private static final long serialVersionUID = 1405915111744728289L;
    private static final BigDecimal INTEGER_MIN_VALUE = new BigDecimal(Integer.MIN_VALUE);
    private static final BigDecimal INTEGER_MAX_VALUE = new BigDecimal(Integer.MAX_VALUE);
    private final int value;

    public IntegerQuantity(int value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return value.compareTo(INTEGER_MIN_VALUE) < 0 || value.compareTo(INTEGER_MAX_VALUE) > 0;
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return NumberQuantity.of(1 / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public boolean isDecimal() {
        return false;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public Class<Integer> getNumberType() {
        return Integer.TYPE;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return (int)value.longValue();
    }

    public Quantity<Q> negate() {
        return new IntegerQuantity(-this.value, this.getUnit());
    }
}

