/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;

final class FloatQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q> {
    private static final long serialVersionUID = 5992028803791009345L;
    private static final BigDecimal FLOAT_MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    final float value;

    public FloatQuantity(float value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return new FloatQuantity<Q>(1.0f / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public int getSize() {
        return 32;
    }

    @Override
    public Class<?> getNumberType() {
        return Float.TYPE;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return Float.valueOf((float)value.doubleValue());
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return value.compareTo(FLOAT_MAX_VALUE.negate()) < 0 || value.compareTo(FLOAT_MAX_VALUE) > 0;
    }

    public Quantity<Q> negate() {
        return new FloatQuantity(-this.value, this.getUnit());
    }
}

