/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;

final class DoubleQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 8660843078156312278L;
    private static final BigDecimal DOUBLE_MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    private final double value;

    public DoubleQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public AbstractQuantity<Q> inverse() {
        return new DoubleQuantity<Q>(1.0 / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public int getSize() {
        return 64;
    }

    @Override
    public Class<?> getNumberType() {
        return Double.TYPE;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return value.doubleValue();
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return value.compareTo(DOUBLE_MAX_VALUE.negate()) < 0 || value.compareTo(DOUBLE_MAX_VALUE) > 0;
    }

    public Quantity<Q> negate() {
        return new DoubleQuantity(-this.value, this.getUnit());
    }
}

