/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;
import tech.units.indriya.quantity.Quantities;

final class DecimalQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = 6504081836032983882L;
    private final BigDecimal value;

    public DecimalQuantity(BigDecimal value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    public DecimalQuantity(double value, Unit<Q> unit) {
        super(unit);
        this.value = BigDecimal.valueOf(value);
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigDecimal.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public boolean isDecimal() {
        return true;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public Class<?> getNumberType() {
        return BigDecimal.class;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return value;
    }

    public DecimalQuantity<Q> negate() {
        return new DecimalQuantity(this.value.negate(), this.getUnit());
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return false;
    }
}

