/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.math.BigDecimal;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;
import tech.units.indriya.quantity.NumberQuantity;

final class ByteQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q> {
    private static final long serialVersionUID = 6325849816534488248L;
    private static final BigDecimal BYTE_MIN_VALUE = new BigDecimal(-128);
    private static final BigDecimal BYTE_MAX_VALUE = new BigDecimal(127);
    private final byte value;

    ByteQuantity(byte value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public boolean isBig() {
        return false;
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return value.compareTo(BYTE_MIN_VALUE) < 0 || value.compareTo(BYTE_MAX_VALUE) > 0;
    }

    @Override
    public ComparableQuantity<?> inverse() {
        return NumberQuantity.of(1 / this.value, this.getUnit().inverse());
    }

    @Override
    public boolean isDecimal() {
        return false;
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public Class<?> getNumberType() {
        return Byte.TYPE;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return (byte)value.longValue();
    }

    public Quantity<Q> negate() {
        return new ByteQuantity(-this.value, this.getUnit());
    }
}

