/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.measure.Quantity;
import javax.measure.Unit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.quantity.JavaNumberQuantity;
import tech.units.indriya.quantity.Quantities;

final class BigIntegerQuantity<Q extends Quantity<Q>>
extends JavaNumberQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = -593014349777834846L;
    private final BigInteger value;

    public BigIntegerQuantity(BigInteger value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    public BigIntegerQuantity(long value, Unit<Q> unit) {
        super(unit);
        this.value = BigInteger.valueOf(value);
    }

    public BigIntegerQuantity<Q> negate() {
        return new BigIntegerQuantity(this.value.negate(), this.getUnit());
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigInteger.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public boolean isDecimal() {
        return false;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @Override
    public Class<?> getNumberType() {
        return BigInteger.class;
    }

    @Override
    Number castFromBigDecimal(BigDecimal value) {
        return value.toBigInteger();
    }

    @Override
    boolean isOverflowing(BigDecimal value) {
        return false;
    }
}

