/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.format.QuantityFormat;
import javax.measure.spi.FormatService;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.NumberSpaceQuantityFormat;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.internal.format.DefaultUnitFormatService;
import tech.uom.lib.common.function.IntPrioritySupplier;

public class DefaultFormatService
extends DefaultUnitFormatService
implements FormatService,
IntPrioritySupplier {
    static final int PRIO = 1000;
    private static final String DEFAULT_FORMAT = "Simple";
    private final Map<String, QuantityFormat> quantityFormats = new HashMap<String, QuantityFormat>();

    public DefaultFormatService() {
        this.quantityFormats.put(DEFAULT_FORMAT, SimpleQuantityFormat.getInstance());
        this.quantityFormats.put("NumberSpace", NumberSpaceQuantityFormat.getInstance());
        this.quantityFormats.put("Local", NumberSpaceQuantityFormat.getInstance(FormatBehavior.LOCALE_SENSITIVE));
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public QuantityFormat getQuantityFormat(String name) {
        return this.quantityFormats.get(name);
    }

    public QuantityFormat getQuantityFormat() {
        return this.getQuantityFormat(DEFAULT_FORMAT);
    }

    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        switch (type) {
            case QUANTITY_FORMAT: {
                return this.quantityFormats.keySet();
            }
        }
        return this.unitFormats.keySet();
    }
}

