/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.Constants;
import tech.uom.lib.common.function.IntExponentSupplier;

public final class PowerOfPiConverter
extends AbstractConverter
implements IntExponentSupplier {
    private static final long serialVersionUID = 5000593326722785126L;
    private final int exponent;
    private final int hashCode;
    private final double doubleFactor;

    public static PowerOfPiConverter of(int exponent) {
        return new PowerOfPiConverter(exponent);
    }

    protected PowerOfPiConverter(int exponent) {
        this.exponent = exponent;
        this.doubleFactor = Math.pow(Math.PI, exponent);
        this.hashCode = Objects.hash(exponent);
    }

    public int getExponent() {
        return this.exponent;
    }

    public boolean isIdentity() {
        return this.exponent == 0;
    }

    public boolean isLinear() {
        return true;
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new PowerOfPiConverter(-this.exponent);
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = Constants.Pi.ofNumDigits(nbrDigits);
        return pi.pow(this.exponent, ctx).multiply(value);
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value * this.doubleFactor;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        return that instanceof PowerOfPiConverter;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        return new PowerOfPiConverter(this.exponent + ((PowerOfPiConverter)that).exponent);
    }

    @Override
    public boolean equals(Object obj) {
        UnitConverter other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnitConverter) {
            other = (UnitConverter)obj;
            if (this.isIdentity() && other.isIdentity()) {
                return true;
            }
        }
        if (obj instanceof PowerOfPiConverter) {
            other = (PowerOfPiConverter)obj;
            return this.exponent == other.exponent;
        }
        return false;
    }

    @Override
    public final String transformationLiteral() {
        return String.format("x -> x * \u03c0^%s", this.exponent);
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (this.isIdentity() && o.isIdentity()) {
            return 0;
        }
        if (o instanceof PowerOfPiConverter) {
            PowerOfPiConverter other = (PowerOfPiConverter)o;
            return Integer.compare(this.exponent, other.exponent);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

