/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.ExpConverter;
import tech.uom.lib.common.function.ValueSupplier;

public final class LogConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = -7584688290961460870L;
    private final double base;
    private final double logOfBase;

    public LogConverter(double base) {
        this.base = base;
        this.logOfBase = Math.log(base);
    }

    public double getBase() {
        return this.base;
    }

    public boolean isIdentity() {
        return false;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        if (that instanceof ExpConverter) {
            return ((ExpConverter)that).getBase() == this.base;
        }
        return false;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new ExpConverter(this.base);
    }

    @Override
    public final String transformationLiteral() {
        if (this.base == Math.E) {
            return "x -> ln(x)";
        }
        return String.format("x -> log(base=%s, x)", this.base);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogConverter) {
            LogConverter that = (LogConverter)obj;
            return Objects.equals(this.base, that.base);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base);
    }

    @Override
    public double convertWhenNotIdentity(double amount) {
        return Math.log(amount) / this.logOfBase;
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.convert(value.doubleValue()));
    }

    public boolean isLinear() {
        return false;
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ValueSupplier) {
            return this.getValue().compareTo(String.valueOf(((ValueSupplier)o).getValue()));
        }
        return -1;
    }
}

