/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.measure.Prefix;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.function.MultiplyConverter;

public final class SymbolMap {
    private static final Logger logger = Logger.getLogger(SymbolMap.class.getName());
    private final Map<String, Unit<?>> symbolToUnit = new TreeMap();
    private final Map<Unit<?>, String> unitToSymbol = new HashMap();
    private final Map<String, Object> symbolToPrefix = new TreeMap<String, Object>();
    private final Map<Object, String> prefixToSymbol = new HashMap<Object, String>();
    private final Map<UnitConverter, Prefix> converterToPrefix = new HashMap<UnitConverter, Prefix>();

    private SymbolMap() {
    }

    private SymbolMap(ResourceBundle rb) {
        this();
        Enumeration<String> i = rb.getKeys();
        while (i.hasMoreElements()) {
            String fqn = i.nextElement();
            String symbol = rb.getString(fqn);
            boolean isAlias = false;
            int lastDot = fqn.lastIndexOf(46);
            String className = fqn.substring(0, lastDot);
            String fieldName = fqn.substring(lastDot + 1, fqn.length());
            if (Character.isDigit(fieldName.charAt(0))) {
                isAlias = true;
                fqn = className;
                lastDot = fqn.lastIndexOf(46);
                className = fqn.substring(0, lastDot);
                fieldName = fqn.substring(lastDot + 1, fqn.length());
            }
            try {
                Class<?> c = Class.forName(className);
                Field field = c.getField(fieldName);
                Object value = field.get(null);
                if (value instanceof Unit) {
                    if (isAlias) {
                        this.alias((Unit)value, symbol);
                        continue;
                    }
                    this.label((AbstractUnit)value, symbol);
                    continue;
                }
                if (value instanceof Prefix) {
                    this.label((Prefix)value, symbol);
                    continue;
                }
                throw new ClassCastException("unable to cast " + value + " to Unit or Prefix");
            }
            catch (Exception error) {
                logger.log(Level.SEVERE, "Error", error);
            }
        }
    }

    public static SymbolMap of(ResourceBundle rb) {
        return new SymbolMap(rb);
    }

    public void label(Unit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
        this.unitToSymbol.put(unit, symbol);
    }

    public void alias(Unit<?> unit, String symbol) {
        this.symbolToUnit.put(symbol, unit);
    }

    public void label(Prefix prefix, String symbol) {
        this.symbolToPrefix.put(symbol, prefix);
        this.prefixToSymbol.put(prefix, symbol);
        this.converterToPrefix.put(MultiplyConverter.of(prefix), prefix);
    }

    public Unit<?> getUnit(String symbol) {
        return this.symbolToUnit.get(symbol);
    }

    public String getSymbol(Unit<?> unit) {
        return this.unitToSymbol.get(unit);
    }

    public Prefix getPrefix(String symbol) {
        List list = this.symbolToPrefix.keySet().stream().collect(Collectors.toList());
        Comparator<String> comparator = Comparator.comparing(String::length);
        Collections.sort(list, comparator.reversed());
        for (String key : list) {
            if (!symbol.startsWith(key)) continue;
            return (Prefix)this.symbolToPrefix.get(key);
        }
        return null;
    }

    public Prefix getPrefix(UnitConverter converter) {
        return this.converterToPrefix.get(converter);
    }

    public String getSymbol(Prefix prefix) {
        return this.prefixToSymbol.get(prefix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tech.units.indriya.format.SymbolMap: [");
        sb.append("symbolToUnit: ").append(this.symbolToUnit).append(',');
        sb.append("unitToSymbol: ").append(this.unitToSymbol).append(',');
        sb.append("symbolToPrefix: ").append(this.symbolToPrefix).append(',');
        sb.append("prefixToSymbol: ").append(this.prefixToSymbol).append(',');
        sb.append("converterToPrefix: ").append(this.converterToPrefix).append(',');
        sb.append("converterToPrefix: ").append(this.converterToPrefix);
        sb.append(" ]");
        return sb.toString();
    }
}

