/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.quantity.Quantities;

final class BigIntegerQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = -593014349777834846L;
    private final BigInteger value;

    public BigIntegerQuantity(BigInteger value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    public BigIntegerQuantity(long value, Unit<Q> unit) {
        super(unit);
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        if (this.getUnit().equals(unit)) {
            return this.value.doubleValue();
        }
        return this.getUnit().getConverterTo(unit).convert(this.value.doubleValue());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit, MathContext ctx) throws ArithmeticException {
        if (this.getUnit().equals(unit)) {
            return new BigDecimal(this.value);
        }
        Number converted = ((AbstractConverter)unit.getConverterTo(unit)).convert(this.value);
        if (converted instanceof BigDecimal) {
            return (BigDecimal)BigDecimal.class.cast(converted);
        }
        if (converted instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(converted));
        }
        return BigDecimal.valueOf(converted.doubleValue());
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.add(AbstractQuantity.Equalizer.toBigInteger(that.getValue())), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.add(AbstractQuantity.Equalizer.toBigInteger(converted.getValue())), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.subtract(AbstractQuantity.Equalizer.toBigInteger(that.getValue())), this.getUnit());
        }
        Quantity converted = that.to(this.getUnit());
        return Quantities.getQuantity(this.value.subtract(AbstractQuantity.Equalizer.toBigInteger(converted.getValue())), this.getUnit());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new BigIntegerQuantity<Q>(this.value.multiply(AbstractQuantity.Equalizer.toBigDecimal(that.getValue()).toBigInteger()), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value.multiply(AbstractQuantity.Equalizer.toBigInteger(that)), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value.divide(AbstractQuantity.Equalizer.toBigDecimal(that).toBigInteger()), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigInteger.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    protected long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new BigIntegerQuantity<Q>(this.value.divide(AbstractQuantity.Equalizer.toBigInteger(that.getValue())), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

