/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.scroll.recycler;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

public class RecyclerPagerScrollListener
extends RecyclerView.OnScrollListener {
    protected int mState = 0;
    protected int mCurrentPosition;
    protected int mNextPosition;
    protected int mOrientation;
    protected int mDx;
    protected int mDy;

    public int getCurrentPosition() {
        return this.mCurrentPosition;
    }

    public int getState() {
        return this.mState;
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        if (this.mState == 2 && newState == 1) {
            return;
        }
        if (newState == 0) {
            this.mCurrentPosition = ((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition();
            this.mDy = 0;
            this.mDx = 0;
            this.mOrientation = ((LinearLayoutManager)recyclerView.getLayoutManager()).getOrientation();
        } else if (newState == 1) {
            this.mCurrentPosition = ((LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition();
            this.mDy = 0;
            this.mDx = 0;
            this.mOrientation = ((LinearLayoutManager)recyclerView.getLayoutManager()).getOrientation();
        } else if (newState == 2 && this.mCurrentPosition != this.mNextPosition) {
            this.onPageSelected(this.mCurrentPosition, this.mNextPosition);
        }
        this.mState = newState;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (this.mOrientation == 0) {
            this.mDx += dx;
            if (this.mDx > 0) {
                this.mNextPosition = this.mCurrentPosition + 1;
            } else if (this.mDx < 0) {
                this.mNextPosition = this.mCurrentPosition - 1;
            }
        } else {
            this.mDy += dy;
            if (this.mDy > 0) {
                this.mNextPosition = this.mCurrentPosition + 1;
            } else if (this.mDy < 0) {
                this.mNextPosition = this.mCurrentPosition - 1;
            }
        }
        if (this.mCurrentPosition != this.mNextPosition) {
            this.onScroll(this.mState, this.mCurrentPosition, this.mNextPosition, this.mDx, this.mDy);
        }
    }

    protected void onPageSelected(int currentPosition, int nextPosition) {
    }

    protected void onScroll(int state, int currentPosition, int nextPosition, int dx, int dy) {
    }
}

