/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.pager;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.PagerSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import tech.threekilogram.pager.pager.PagerLinearLayoutManager;

public class RecyclerPager
extends RecyclerView {
    private int mCurrentPosition;

    public RecyclerPager(Context context) {
        this(context, null, 0);
    }

    public RecyclerPager(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerPager(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        PagerLinearLayoutManager layoutManager = new PagerLinearLayoutManager(this.getContext());
        layoutManager.setOrientation(0);
        this.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        PagerSnapHelper snapHelper = new PagerSnapHelper();
        snapHelper.attachToRecyclerView((RecyclerView)this);
        this.addOnScrollListener(new GetCurrentScrollListener());
    }

    public void setOrientation(int orientation) {
        ((LinearLayoutManager)this.getLayoutManager()).setOrientation(orientation);
    }

    public int getCurrentPosition() {
        return this.mCurrentPosition;
    }

    public View getCurrentView() {
        return this.getLayoutManager().findViewByPosition(this.mCurrentPosition);
    }

    public void scrollToPosition(int position) {
        super.scrollToPosition(position);
        this.mCurrentPosition = position;
    }

    public void smoothScrollToPosition(int position) {
        super.smoothScrollToPosition(position);
        this.mCurrentPosition = position;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if ((ev.getAction() == 0 || ev.getAction() == 1) && this.getScrollState() == 0) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)this.getLayoutManager();
            this.mCurrentPosition = layoutManager.findFirstVisibleItemPosition();
        }
        return super.dispatchTouchEvent(ev);
    }

    private class GetCurrentScrollListener
    extends RecyclerView.OnScrollListener {
        private GetCurrentScrollListener() {
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0) {
                LinearLayoutManager layoutManager = (LinearLayoutManager)RecyclerPager.this.getLayoutManager();
                RecyclerPager.this.mCurrentPosition = layoutManager.findFirstVisibleItemPosition();
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (dx == 0 && recyclerView.getScrollState() == 0) {
                LinearLayoutManager layoutManager = (LinearLayoutManager)RecyclerPager.this.getLayoutManager();
                RecyclerPager.this.mCurrentPosition = layoutManager.findFirstVisibleItemPosition();
            }
        }
    }
}

