/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.pager;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.animation.Interpolator;
import java.lang.reflect.Field;
import tech.threekilogram.pager.pager.DurationAddScroller;

public class ExtendViewPager
extends ViewPager {
    protected DurationAddScroller mScroller;
    protected boolean mCallSuperRequestLayout;

    public ExtendViewPager(Context context) {
        this(context, null);
    }

    public ExtendViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void init() {
        this.attachViewPagerScroller();
    }

    public void requestLayout() {
        this.mCallSuperRequestLayout = true;
        super.requestLayout();
        this.mCallSuperRequestLayout = false;
    }

    public void setCurrentItem(int item, boolean smoothScroll, int scrollDurationAdded) {
        if (this.mScroller != null) {
            this.mScroller.setDurationAdded(scrollDurationAdded);
        }
        super.setCurrentItem(item, smoothScroll);
        if (this.mScroller != null) {
            this.mScroller.setDurationAdded(0);
        }
    }

    public void smoothScrollToNextItem() {
        this.setCurrentItem(this.getCurrentItem() + 1, true);
    }

    public void smoothScrollToNextItem(int scrollDurationAdded) {
        this.setCurrentItem(this.getCurrentItem() + 1, true, scrollDurationAdded);
    }

    public void smoothScrollToPrevItem() {
        this.setCurrentItem(this.getCurrentItem() - 1, true);
    }

    public void smoothScrollToPrevItem(int scrollDurationAdded) {
        this.setCurrentItem(this.getCurrentItem() - 1, true, scrollDurationAdded);
    }

    public boolean isCallSuperRequestLayout() {
        return this.mCallSuperRequestLayout;
    }

    public void setClip(boolean b) {
        this.setClipChildren(b);
        this.setClipToPadding(b);
    }

    public void abortScroller() {
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
    }

    private void attachViewPagerScroller() {
        try {
            Field scrollerInPager = ViewPager.class.getDeclaredField("mScroller");
            scrollerInPager.setAccessible(true);
            Field interpolator = ViewPager.class.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new DurationAddScroller(this.getContext(), (Interpolator)interpolator.get(null));
            scrollerInPager.set((Object)this, (Object)this.mScroller);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

