/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.indicator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import tech.threekilogram.pager.banner.ViewPagerBanner;

public class DotView
extends View {
    private int mColorSelected;
    private int mColorNormal;
    private Paint mPaint;
    private int mDotMargin;
    private int mDotSize;
    private int mDotCount;
    private boolean[] mSelect;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;

    public DotView(Context context) {
        this(context, null, 0);
    }

    public DotView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DotView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mColorNormal = -3355444;
        this.mColorSelected = -1;
        this.mDotSize = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mDotMargin = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setColor(int colorSelected, int colorNormal) {
        this.mColorSelected = colorSelected;
        this.mColorNormal = colorNormal;
    }

    public void setColorNormal(int colorNormal) {
        this.mColorNormal = colorNormal;
    }

    public void setColorSelected(int colorSelected) {
        this.mColorSelected = colorSelected;
    }

    public void setDotMargin(int dotMargin) {
        this.mDotMargin = dotMargin;
        this.requestLayout();
    }

    public void setDotSize(int dotSize) {
        this.mDotSize = dotSize;
        this.requestLayout();
    }

    public void setDotCount(int dotCount) {
        this.mDotCount = dotCount;
        boolean[] temp = new boolean[dotCount];
        if (this.mSelect != null) {
            int count = Math.min(dotCount, this.mSelect.length);
            for (int i = 0; i < count; ++i) {
                try {
                    temp[i] = this.mSelect[i];
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
        }
        this.mSelect = temp;
        this.requestLayout();
    }

    public void setSelected(int index) {
        if (this.mSelect[index]) {
            return;
        }
        for (int i = 0; i < this.mSelect.length; ++i) {
            this.mSelect[i] = false;
        }
        this.mSelect[index] = true;
        this.invalidate();
    }

    public void setupWithBanner(ViewPagerBanner banner, int gravity, int margin) {
        this.setDotCount(banner.getItemCount());
        this.setSelected(banner.getCurrentItem());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = gravity;
        params.leftMargin = margin;
        params.topMargin = margin;
        params.rightMargin = margin;
        params.bottomMargin = margin;
        banner.addView(this, (ViewGroup.LayoutParams)params);
        if (this.mOnPageChangeListener != null) {
            banner.removeOnPageChangeListener(this.mOnPageChangeListener);
        }
        this.mOnPageChangeListener = new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                DotView.this.setSelected(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        };
        banner.addOnPageChangeListener(this.mOnPageChangeListener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int finalWidth = 0;
        int finalHeight = 0;
        if (widthMode == 0x40000000) {
            finalWidth = widthSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            int minContentWidth = (this.mDotSize + this.mDotMargin) * this.mDotCount - this.mDotMargin;
            finalWidth = Math.min(minContentWidth, widthSize);
        } else {
            finalWidth = (this.mDotSize + this.mDotMargin) * this.mDotCount - this.mDotMargin;
        }
        finalHeight = heightMode == 0x40000000 ? heightSize : (widthMode == Integer.MIN_VALUE ? Math.min(this.mDotSize, heightSize) : this.mDotSize);
        this.setMeasuredDimension(finalWidth, finalHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int radius = this.mDotSize / 2 - 1;
        int dotsWidth = (this.mDotSize + this.mDotMargin) * this.mDotCount - this.mDotMargin;
        int ry = this.getHeight() / 2;
        int startX = (this.getWidth() - dotsWidth) / 2;
        for (int i = 0; i < this.mDotCount; ++i) {
            if (this.mSelect[i]) {
                this.mPaint.setColor(this.mColorSelected);
            } else {
                this.mPaint.setColor(this.mColorNormal);
            }
            canvas.drawCircle((float)(radius + startX + i * (this.mDotSize + this.mDotMargin)), (float)ry, (float)radius, this.mPaint);
        }
    }
}

