/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.banner;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import tech.threekilogram.pager.banner.LoopHandlerLayout;
import tech.threekilogram.pager.banner.MaxCountAdapter;
import tech.threekilogram.pager.pager.ExtendViewPager;

public class ViewPagerBanner
extends LoopHandlerLayout {
    protected ExtendViewPager mViewPager;
    protected int mScrollDurationAdded = 1000;
    protected BannerPagerChangeListener mPagerChangeListener;

    public ViewPagerBanner(@NonNull Context context) {
        this(context, null, 0);
    }

    public ViewPagerBanner(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewPagerBanner(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mViewPager = this.createPager(this.getContext());
        this.addView((View)this.mViewPager, 0);
        this.setClip(false);
        this.mViewPager.setClip(false);
    }

    protected ExtendViewPager createPager(Context context) {
        return new ExtendViewPager(context);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.onTouchPauseLoop(ev);
        return super.dispatchTouchEvent(ev);
    }

    public void setScrollDurationAdded(int scrollDurationAdded) {
        this.mScrollDurationAdded = scrollDurationAdded;
    }

    public int getScrollDurationAdded() {
        return this.mScrollDurationAdded;
    }

    public void setBannerAdapter(PagerAdapter adapter) {
        MaxCountAdapter maxCountAdapter = new MaxCountAdapter(adapter);
        this.mViewPager.setAdapter(maxCountAdapter);
        this.mViewPager.setCurrentItem(maxCountAdapter.getStartPosition());
        if (this.mOnLoopListener == null || !(this.mOnLoopListener instanceof BannerOnLoopListener)) {
            this.mOnLoopListener = new BannerOnLoopListener();
        }
        this.setOnLoopListener(this.mOnLoopListener);
    }

    public PagerAdapter getBannerAdapter() {
        MaxCountAdapter adapter = (MaxCountAdapter)this.mViewPager.getAdapter();
        return adapter == null ? null : adapter.getPagerAdapter();
    }

    public int getItemCount() {
        MaxCountAdapter adapter = (MaxCountAdapter)this.mViewPager.getAdapter();
        return adapter == null ? 0 : adapter.getAdapterCount();
    }

    public int getCurrentItem() {
        int currentItem = this.mViewPager.getCurrentItem();
        MaxCountAdapter adapter = (MaxCountAdapter)this.mViewPager.getAdapter();
        return adapter == null ? currentItem : adapter.getAdapterPosition(currentItem);
    }

    public int getItemAdapterPosition(int position) {
        MaxCountAdapter adapter = (MaxCountAdapter)this.mViewPager.getAdapter();
        if (adapter != null) {
            adapter.getAdapterPosition(position);
        }
        return -1;
    }

    public void setCurrentItem(int item) {
        this.mViewPager.setCurrentItem(item);
    }

    public void addOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        if (this.mPagerChangeListener == null) {
            this.mPagerChangeListener = new BannerPagerChangeListener();
            this.mViewPager.setOnPageChangeListener(this.mPagerChangeListener);
        }
        this.mPagerChangeListener.add(listener);
    }

    public void removeOnPageChangeListener(@NonNull ViewPager.OnPageChangeListener listener) {
        if (this.mPagerChangeListener != null) {
            this.mPagerChangeListener.remove(listener);
        }
    }

    public void clearOnPageChangeListeners() {
        if (this.mPagerChangeListener != null) {
            this.mPagerChangeListener.clear();
        }
    }

    public void setPageTransformer(boolean reverseDrawingOrder, @Nullable ViewPager.PageTransformer transformer) {
        this.mViewPager.setPageTransformer(reverseDrawingOrder, transformer);
    }

    public void setPageMargin(int marginPixels) {
        this.mViewPager.setPageMargin(marginPixels);
    }

    public int getPageMargin() {
        return this.mViewPager.getPageMargin();
    }

    public void setPageMarginDrawable(@Nullable Drawable d) {
        this.mViewPager.setPageMarginDrawable(d);
    }

    public void setPageMarginDrawable(@DrawableRes int resId) {
        this.setPageMarginDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)resId));
    }

    private class BannerPagerChangeListener
    implements ViewPager.OnPageChangeListener {
        private ArrayList<ViewPager.OnPageChangeListener> mOnPageChangeListeners = new ArrayList();

        private BannerPagerChangeListener() {
        }

        private void add(ViewPager.OnPageChangeListener listener) {
            this.mOnPageChangeListeners.add(listener);
        }

        private void remove(ViewPager.OnPageChangeListener listener) {
            this.mOnPageChangeListeners.remove(listener);
        }

        private void clear() {
            this.mOnPageChangeListeners.clear();
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            MaxCountAdapter adapter = (MaxCountAdapter)ViewPagerBanner.this.mViewPager.getAdapter();
            if (adapter != null) {
                position = adapter.getAdapterPosition(position);
                for (ViewPager.OnPageChangeListener onPageChangeListener : this.mOnPageChangeListeners) {
                    onPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }
            }
        }

        public void onPageSelected(int position) {
            MaxCountAdapter adapter = (MaxCountAdapter)ViewPagerBanner.this.mViewPager.getAdapter();
            if (adapter != null) {
                position = adapter.getAdapterPosition(position);
                for (ViewPager.OnPageChangeListener onPageChangeListener : this.mOnPageChangeListeners) {
                    onPageChangeListener.onPageSelected(position);
                }
            }
        }

        public void onPageScrollStateChanged(int state) {
            for (ViewPager.OnPageChangeListener onPageChangeListener : this.mOnPageChangeListeners) {
                onPageChangeListener.onPageScrollStateChanged(state);
            }
        }
    }

    private class BannerOnLoopListener
    implements LoopHandlerLayout.OnLoopListener {
        private BannerOnLoopListener() {
        }

        @Override
        public void onLoop(LoopHandlerLayout layout) {
            ViewPagerBanner.this.mViewPager.smoothScrollToNextItem(ViewPagerBanner.this.mScrollDurationAdded);
        }
    }
}

