/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.banner;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import tech.threekilogram.pager.banner.LoopHandlerLayout;
import tech.threekilogram.pager.pager.DurationAddSmoothScroller;
import tech.threekilogram.pager.pager.RecyclerPager;

public class RecyclerPagerBanner
extends LoopHandlerLayout {
    protected RecyclerPager mRecyclerPager;
    protected DurationAddSmoothScroller mSmoothScroller;

    public RecyclerPagerBanner(@NonNull Context context) {
        this(context, null, 0);
    }

    public RecyclerPagerBanner(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerPagerBanner(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init() {
        super.init();
        this.mSmoothScroller = new DurationAddSmoothScroller(this.getContext());
        this.mSmoothScroller.setDurationAdded(120);
        this.mRecyclerPager = this.createPager(this.getContext());
        this.addView((View)this.mRecyclerPager, 0);
    }

    protected RecyclerPager createPager(Context context) {
        return new RecyclerPager(context);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.onTouchPauseLoop(ev);
        return super.dispatchTouchEvent(ev);
    }

    public RecyclerPager getRecyclerPager() {
        return this.mRecyclerPager;
    }

    public int getCurrentPosition() {
        return this.getRecyclerPager().getCurrentPosition();
    }

    public View getCurrentItemView() {
        return this.getRecyclerPager().getCurrentView();
    }

    public void setBannerAdapter(BannerAdapter adapter) {
        this.mRecyclerPager.setAdapter(adapter);
        this.mRecyclerPager.scrollToPosition(adapter.getStartPosition());
        if (this.mOnLoopListener == null || !(this.mOnLoopListener instanceof BannerOnLoopListener)) {
            this.mOnLoopListener = new BannerOnLoopListener();
        }
        this.setOnLoopListener(this.mOnLoopListener);
    }

    public BannerAdapter getBannerAdapter() {
        return (BannerAdapter)this.mRecyclerPager.getAdapter();
    }

    public void addScrollDuration(int duration) {
        this.mSmoothScroller.setDurationAdded(duration);
    }

    public int getAddScrollDuration() {
        return this.mSmoothScroller.getDurationAdded();
    }

    public void addOnScrollListener(RecyclerView.OnScrollListener listener) {
        this.mRecyclerPager.addOnScrollListener(listener);
    }

    public void removeOnScrollListener(RecyclerView.OnScrollListener listener) {
        this.mRecyclerPager.removeOnScrollListener(listener);
    }

    public void clearOnScrollListeners() {
        this.mRecyclerPager.clearOnScrollListeners();
    }

    public void smoothToNext() {
        RecyclerView.LayoutManager layoutManager = this.mRecyclerPager.getLayoutManager();
        int itemPosition = ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
        if (itemPosition + 1 < Integer.MAX_VALUE) {
            this.mSmoothScroller.setTargetPosition(itemPosition + 1);
            layoutManager.startSmoothScroll((RecyclerView.SmoothScroller)this.mSmoothScroller);
        }
    }

    public void smoothToPrev() {
        int itemPosition = ((LinearLayoutManager)this.mRecyclerPager.getLayoutManager()).findFirstCompletelyVisibleItemPosition();
        if (itemPosition - 1 >= 0) {
            this.mRecyclerPager.smoothScrollToPosition(itemPosition - 1);
        }
    }

    public static abstract class BannerAdapter<VH extends RecyclerView.ViewHolder>
    extends RecyclerView.Adapter<VH> {
        public int getItemCount() {
            return Integer.MAX_VALUE;
        }

        public abstract int getActualCount();

        public int getStartPosition() {
            int i = 0x3FFFFFFF;
            if (this.getActualCount() == 0) {
                return i;
            }
            return i - i % this.getActualCount();
        }

        public int getActualPosition(int position) {
            return position % this.getActualCount();
        }
    }

    private class BannerOnLoopListener
    implements LoopHandlerLayout.OnLoopListener {
        private BannerOnLoopListener() {
        }

        @Override
        public void onLoop(LoopHandlerLayout layout) {
            RecyclerPagerBanner.this.smoothToNext();
        }
    }
}

