/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.banner;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import java.lang.ref.WeakReference;

public class LoopHandlerLayout
extends FrameLayout {
    private static final String TAG = LoopHandlerLayout.class.getSimpleName();
    protected LoopHandler mLoopHandler;
    protected boolean isAutoLoop;
    protected int mLoopTime;
    protected OnLoopListener mOnLoopListener;
    protected boolean isTouchPaused = false;

    public LoopHandlerLayout(@NonNull Context context) {
        this(context, null);
    }

    public LoopHandlerLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoopHandlerLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void init() {
        this.mLoopHandler = new LoopHandler(this);
    }

    public void setOnLoopListener(OnLoopListener onLoopListener) {
        this.mOnLoopListener = onLoopListener;
    }

    public OnLoopListener getOnLoopListener() {
        return this.mOnLoopListener;
    }

    protected void setClip(boolean clipOrNot) {
        this.setClipChildren(clipOrNot);
        this.setClipToPadding(clipOrNot);
    }

    public void onTouchPauseLoop(MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 4) {
            if (this.isTouchPaused) {
                this.isTouchPaused = false;
                if (this.isAutoLoop) {
                    this.mLoopHandler.sendDelayedLoop(this.mLoopTime);
                }
            }
        } else if (!this.isTouchPaused) {
            this.isTouchPaused = true;
            this.mLoopHandler.removeLoop();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mLoopHandler.removeCallbacksAndMessages(null);
    }

    public boolean isAutoLoop() {
        return this.isAutoLoop;
    }

    public void startLoop() {
        this.startLoop(2400);
    }

    public void startLoop(int loopTime) {
        this.isAutoLoop = true;
        this.mLoopTime = loopTime;
        this.mLoopHandler.sendDelayedLoop(loopTime);
    }

    public void stopLoop() {
        this.isAutoLoop = false;
        this.mLoopHandler.removeLoop();
    }

    public static interface OnLoopListener {
        public void onLoop(LoopHandlerLayout var1);
    }

    private static class LoopHandler
    extends Handler {
        private static final int WHAT_LOOP = 1569;
        private WeakReference<LoopHandlerLayout> mRef;

        LoopHandler(LoopHandlerLayout banner) {
            this.mRef = new WeakReference<LoopHandlerLayout>(banner);
        }

        private void sendDelayedLoop(int delayed) {
            if (this.isLooping()) {
                return;
            }
            this.sendEmptyMessageDelayed(1569, delayed);
        }

        private boolean isLooping() {
            return this.hasMessages(1569);
        }

        private void removeLoop() {
            if (this.isLooping()) {
                this.removeMessages(1569);
            }
        }

        public void handleMessage(Message msg) {
            LoopHandlerLayout loopHandlerLayout = (LoopHandlerLayout)((Object)this.mRef.get());
            if (loopHandlerLayout == null) {
                return;
            }
            if (msg.what == 1569) {
                OnLoopListener loopListener = loopHandlerLayout.mOnLoopListener;
                if (loopListener != null) {
                    loopListener.onLoop(loopHandlerLayout);
                }
                if (loopHandlerLayout.isAutoLoop) {
                    this.sendEmptyMessageDelayed(1569, loopHandlerLayout.mLoopTime);
                }
            }
        }
    }
}

