/*
 * Decompiled with CFR 0.152.
 */
package tech.threekilogram.pager.adapter;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import tech.threekilogram.pager.adapter.BaseTypePagerAdapter;
import tech.threekilogram.pager.adapter.PagerItemInfo;

class TypePagerItemPool {
    private SparseArray<ArrayList<PagerItemInfo>> mTypeItems;
    private BaseTypePagerAdapter mPagerAdapter;

    TypePagerItemPool(BaseTypePagerAdapter pagerAdapter) {
        this.mPagerAdapter = pagerAdapter;
        this.mTypeItems = new SparseArray();
    }

    public PagerItemInfo getPagerItemInfo(ViewGroup container, int position) {
        int type = this.mPagerAdapter.getViewType(position);
        ArrayList<PagerItemInfo> itemInfoList = (ArrayList<PagerItemInfo>)this.mTypeItems.get(type);
        if (itemInfoList == null) {
            itemInfoList = new ArrayList<PagerItemInfo>();
            this.mTypeItems.put(type, itemInfoList);
        }
        PagerItemInfo info = null;
        for (int i = 0; i < itemInfoList.size(); ++i) {
            PagerItemInfo infoNew = (PagerItemInfo)itemInfoList.get(i);
            if (infoNew.getPosition() != -1) continue;
            info = infoNew;
            break;
        }
        if (info == null) {
            info = new PagerItemInfo();
            itemInfoList.add(info);
        }
        info.setPosition(position);
        Object data = this.mPagerAdapter.getData(position, this.mPagerAdapter.getViewType(position));
        info.setData(data);
        Object view = info.getView();
        if (view == null) {
            view = this.mPagerAdapter.getView(container, position, type);
            info.setView(view);
        }
        this.mPagerAdapter.bindData(position, data, (View)view, type);
        return info;
    }

    public PagerItemInfo getPagerItem(int position) {
        int type = this.mPagerAdapter.getViewType(position);
        ArrayList itemsInfoList = (ArrayList)this.mTypeItems.get(type);
        if (itemsInfoList == null) {
            return null;
        }
        int size = itemsInfoList.size();
        for (int i = 0; i < size; ++i) {
            PagerItemInfo item = (PagerItemInfo)itemsInfoList.get(i);
            if (item.getPosition() != position) continue;
            return item;
        }
        return null;
    }
}

