/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.plot;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javax.swing.SwingUtilities;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.plotting.fx.FxBar;
import tech.tablesaw.plotting.fx.FxPlot;
import tech.tablesaw.reducing.NumericSummaryTable;

public class Bar
extends FxPlot {
    private static final String WINDOW_TITLE = "Tablesaw";

    public static void show(String title, CategoryColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                Bar.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, ShortColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                Bar.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, IntColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                Bar.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, NumericSummaryTable table) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                if (table.column(0) instanceof CategoryColumn) {
                    Bar.initAndShowGUI(title, table.categoryColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof ShortColumn) {
                    Bar.initAndShowGUI(title, table.shortColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof IntColumn) {
                    Bar.initAndShowGUI(title, table.intColumn(0), table.nCol(1), 640, 480);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void initAndShowGUI(String title, CategoryColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = Bar.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<String, Number> chart = FxBar.chart(title, categoryColumn, numericColumn);
        Platform.runLater(() -> Bar.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, ShortColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = Bar.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<String, Number> chart = FxBar.chart(title, categoryColumn, numericColumn);
        Platform.runLater(() -> Bar.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, IntColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = Bar.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<String, Number> chart = FxBar.chart(title, categoryColumn, numericColumn);
        Platform.runLater(() -> Bar.initFX(fxPanel, chart));
    }

    private static void initFX(JFXPanel fxPanel, BarChart<String, Number> chart) {
        Scene scene = new Scene(chart, chart.getWidth(), chart.getHeight());
        fxPanel.setScene(scene);
    }
}

