/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.plot;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javafx.scene.chart.BarChart;
import javax.swing.SwingUtilities;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.plotting.fx.FxHorizontalBar;
import tech.tablesaw.plotting.fx.FxPlot;
import tech.tablesaw.reducing.NumericSummaryTable;

public class HorizontalBar
extends FxPlot {
    private static final String WINDOW_TITLE = "Tablesaw";

    public static void show(String title, CategoryColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                HorizontalBar.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, ShortColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                HorizontalBar.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, IntColumn categoryColumn, NumericColumn numericColumn) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                HorizontalBar.initAndShowGUI(title, categoryColumn, numericColumn, 640, 480);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void show(String title, NumericSummaryTable table) throws Exception {
        SwingUtilities.invokeLater(() -> {
            try {
                if (table.column(0) instanceof CategoryColumn) {
                    HorizontalBar.initAndShowGUI(title, table.categoryColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof ShortColumn) {
                    HorizontalBar.initAndShowGUI(title, table.shortColumn(0), table.nCol(1), 640, 480);
                }
                if (table.column(0) instanceof IntColumn) {
                    HorizontalBar.initAndShowGUI(title, table.intColumn(0), table.nCol(1), 640, 480);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static void initAndShowGUI(String title, CategoryColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = HorizontalBar.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<Number, String> chart = FxHorizontalBar.chart("", categoryColumn, numericColumn);
        Platform.runLater(() -> HorizontalBar.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, ShortColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = HorizontalBar.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<Number, String> chart = FxHorizontalBar.chart("", categoryColumn, numericColumn);
        Platform.runLater(() -> HorizontalBar.initFX(fxPanel, chart));
    }

    private static void initAndShowGUI(String title, IntColumn categoryColumn, NumericColumn numericColumn, int width, int height) throws Exception {
        JFXPanel fxPanel = HorizontalBar.getJfxPanel(WINDOW_TITLE, width, height);
        BarChart<Number, String> chart = FxHorizontalBar.chart("", categoryColumn, numericColumn);
        Platform.runLater(() -> HorizontalBar.initFX(fxPanel, chart));
    }

    private static void initFX(JFXPanel fxPanel, BarChart<Number, String> chart) {
        Scene scene = new Scene(chart, chart.getWidth(), chart.getHeight());
        fxPanel.setScene(scene);
    }
}

