/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.smile;

import java.awt.Component;
import javax.swing.JFrame;
import smile.plot.BoxPlot;
import smile.plot.PlotCanvas;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotting.smile.SmilePlotUtils;
import tech.tablesaw.table.TableSlice;
import tech.tablesaw.table.TableSliceGroup;
import tech.tablesaw.util.DoubleArrays;

public class SmileBox {
    public static void show(String title, TableSliceGroup data, int columnIndex) {
        PlotCanvas canvas = SmileBox.create(title, data, columnIndex);
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }

    public static void show(String title, Table table, String summaryColumnName, String groupingColumnName) {
        PlotCanvas canvas = SmileBox.create(title, table, summaryColumnName, groupingColumnName);
        JFrame frame = SmilePlotUtils.getjFrame(600, 400);
        frame.add((Component)canvas);
        frame.setVisible(true);
    }

    public static PlotCanvas create(String plotTitle, TableSliceGroup groups, int columnNumber) {
        double[][] dataArray = DoubleArrays.to2dArray((TableSliceGroup)groups, (int)columnNumber);
        String[] grounpNames = SmileBox.groupNames(groups);
        PlotCanvas canvas = BoxPlot.plot((double[][])dataArray, (String[])grounpNames);
        canvas.setTitle(plotTitle);
        canvas.setAxisLabel(0, "");
        canvas.setAxisLabel(1, groups.getSourceTable().column(columnNumber).name());
        return canvas;
    }

    public static PlotCanvas create(String plotTitle, Table table, String summaryColumnName, String groupingColumnName) {
        TableSliceGroup groups = table.splitOn(new CategoricalColumn[]{table.categoricalColumn(groupingColumnName)});
        int columnNumber = table.columnIndex(summaryColumnName);
        double[][] dataArray = DoubleArrays.to2dArray((TableSliceGroup)groups, (int)columnNumber);
        String[] grounpNames = SmileBox.groupNames(groups);
        PlotCanvas canvas = BoxPlot.plot((double[][])dataArray, (String[])grounpNames);
        canvas.setTitle(plotTitle);
        canvas.setAxisLabel(0, groupingColumnName);
        canvas.setAxisLabel(1, summaryColumnName);
        return canvas;
    }

    private static String[] groupNames(TableSliceGroup groups) {
        String[] result = new String[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            TableSlice view = groups.get(i);
            result[i] = view.name();
        }
        return result;
    }
}

