/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.plot;

import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.plotting.xchart.XchartLine;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class Control {
    public static void show(String name, NumberColumn data) {
        Control.show(name, data, 0, data.size());
    }

    public static void show(String name, NumberColumn sourceData, int controlRangeStart, int controlRangeEnd) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(controlRangeStart, controlRangeEnd);
        NumberColumn data = (NumberColumn)sourceData.subset((Selection)selection);
        double avg = data.mean();
        double stdDev = data.standardDeviation();
        double controlLimit = 3.0 * stdDev;
        Control.show(name, data, avg, controlLimit);
    }

    public static void show(String name, NumberColumn data, double avg, double controlLimit) {
        DoubleColumn index = DoubleColumn.create((String)"Observations");
        DoubleColumn mean = DoubleColumn.create((String)"Mean");
        DoubleColumn ucl = DoubleColumn.create((String)"UCL");
        DoubleColumn lcl = DoubleColumn.create((String)"LCL");
        for (int i = 0; i < data.size(); ++i) {
            index.append((float)(i + 1));
            mean.append(avg);
            ucl.append(avg + controlLimit);
            lcl.append(avg - controlLimit);
        }
        XchartLine.show(name, (NumberColumn)index, new NumberColumn[]{data, mean, ucl, lcl});
    }
}

