/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotting.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.chart.PieChart;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotting.fx.FxBuilder;

public class FxPie
extends FxBuilder {
    public static PieChart chart(String title, Table table, String categoryColumnName, String numericColumnName) {
        CategoryColumn categoryColumn = table.categoryColumn(categoryColumnName);
        NumericColumn numericColumn = table.nCol(numericColumnName);
        return FxPie.chart(title, categoryColumn, numericColumn);
    }

    public static PieChart chart(String title, CategoryColumn categoryColumn, NumericColumn numericColumn) {
        ArrayList<PieChart.Data> data = new ArrayList<PieChart.Data>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            data.add(new PieChart.Data(categoryColumn.getString(i), numericColumn.getDouble(i)));
        }
        return FxPie.createChart(title, data);
    }

    public static PieChart chart(String title, ShortColumn categoryColumn, NumericColumn numericColumn) {
        ArrayList<PieChart.Data> data = new ArrayList<PieChart.Data>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            String name = Short.toString(categoryColumn.get(i));
            data.add(new PieChart.Data(name, numericColumn.getDouble(i)));
        }
        return FxPie.createChart(title, data);
    }

    public static PieChart chart(String title, IntColumn categoryColumn, NumericColumn numericColumn) {
        ArrayList<PieChart.Data> data = new ArrayList<PieChart.Data>(categoryColumn.size());
        for (int i = 0; i < categoryColumn.size(); ++i) {
            String name = Integer.toString(categoryColumn.get(i));
            data.add(new PieChart.Data(name, numericColumn.getDouble(i)));
        }
        return FxPie.createChart(title, data);
    }

    private static PieChart createChart(String title, List<PieChart.Data> data) {
        PieChart pieChart = FxPie.getPieChart(title);
        pieChart.getData().setAll(data);
        return pieChart;
    }
}

