/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.api;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.ScatterTrace;

public abstract class PricePlot {
    public static Figure create(String title, Table table, String xCol, String openCol, String highCol, String lowCol, String closeCol, String plotType) {
        ScatterTrace trace;
        Layout layout = Layout.builder(title, xCol).build();
        Column x = table.column(xCol);
        NumericColumn open = table.numberColumn(openCol);
        NumericColumn high = table.numberColumn(highCol);
        NumericColumn low = table.numberColumn(lowCol);
        NumericColumn close = table.numberColumn(closeCol);
        if (x.type() == ColumnType.LOCAL_DATE) {
            trace = ScatterTrace.builder(table.dateColumn(xCol), (NumericColumn<? extends Number>)open, (NumericColumn<? extends Number>)high, (NumericColumn<? extends Number>)low, (NumericColumn<? extends Number>)close).type(plotType).build();
        } else if (x.type() == ColumnType.LOCAL_DATE_TIME) {
            trace = ScatterTrace.builder(table.dateTimeColumn(xCol), (NumericColumn<? extends Number>)open, (NumericColumn<? extends Number>)high, (NumericColumn<? extends Number>)low, (NumericColumn<? extends Number>)close).type(plotType).build();
        } else if (x.type() == ColumnType.INSTANT) {
            trace = ScatterTrace.builder(table.instantColumn(xCol), (NumericColumn<? extends Number>)open, (NumericColumn<? extends Number>)high, (NumericColumn<? extends Number>)low, (NumericColumn<? extends Number>)close).type(plotType).build();
        } else {
            throw new IllegalArgumentException("Column containing data for the X-Axis must be of type INSTANT, LOCAL_DATE, or LOCAL_DATE_TIME");
        }
        return new Figure(layout, trace);
    }
}

