/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.api;

import java.util.List;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.ScatterTrace;
import tech.tablesaw.plotly.traces.Trace;
import tech.tablesaw.table.TableSliceGroup;

public class TimeSeriesPlot {
    private static final int HEIGHT = 600;
    private static final int WIDTH = 800;

    public static Figure create(String title, Table table, String dateColX, String yCol, String groupCol) {
        TableSliceGroup tables = table.splitOn(new CategoricalColumn[]{table.categoricalColumn(groupCol)});
        Layout layout = TimeSeriesPlot.standardLayout(title, dateColX, yCol);
        Trace[] traces = new ScatterTrace[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            List tableList = tables.asTableList();
            Table t = ((Table)tableList.get(i)).sortOn(new String[]{"date"});
            traces[i] = ScatterTrace.builder(t.dateColumn(dateColX), (NumericColumn<? extends Number>)t.numberColumn(yCol)).showLegend(true).name(((Table)tableList.get(i)).name()).mode(ScatterTrace.Mode.LINE).build();
        }
        return new Figure(layout, traces);
    }

    public static Figure create(String title, Table table, String dateColXName, String yColName) {
        Layout layout = TimeSeriesPlot.standardLayout(title, dateColXName, yColName);
        ScatterTrace trace = ScatterTrace.builder(table.column(dateColXName), (NumericColumn<? extends Number>)table.numberColumn(yColName)).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }

    public static Figure create(String title, String xTitle, DateColumn xCol, String yTitle, NumberColumn<?> yCol) {
        Layout layout = TimeSeriesPlot.standardLayout(title, xTitle, yTitle);
        ScatterTrace trace = ScatterTrace.builder(xCol, yCol).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }

    private static Layout standardLayout(String title, String xTitle, String yTitle) {
        return Layout.builder().title(title).height(600).width(800).xAxis(Axis.builder().title(xTitle).build()).yAxis(Axis.builder().title(yTitle).build()).build();
    }
}

