/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class Histogram2DTrace
extends AbstractTrace {
    private final double[] x;
    private final double[] y;

    public static Histogram2DBuilder builder(double[] x, double[] y) {
        return new Histogram2DBuilder(x, y);
    }

    public static Histogram2DBuilder builder(NumericColumn<? extends Number> x, NumericColumn<? extends Number> y) {
        return new Histogram2DBuilder(x.asDoubleArray(), y.asDoubleArray());
    }

    private Histogram2DTrace(Histogram2DBuilder builder) {
        super(builder);
        this.x = builder.x;
        this.y = builder.y;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("x", Utils.dataAsString(this.x));
        context.put("y", Utils.dataAsString(this.y));
        return context;
    }

    public static class Histogram2DBuilder
    extends TraceBuilder {
        final String type = "histogram2d";
        final double[] x;
        final double[] y;

        private Histogram2DBuilder(double[] x, double[] y) {
            this.x = x;
            this.y = y;
        }

        public Histogram2DTrace build() {
            return new Histogram2DTrace(this);
        }

        @Override
        protected String getType() {
            return "histogram2d";
        }
    }
}

