/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class BarTrace
extends AbstractTrace {
    private final Object[] x;
    private final double[] y;
    private final Orientation orientation;

    private BarTrace(BarBuilder builder) {
        super(builder);
        this.orientation = builder.orientation;
        this.x = builder.x;
        this.y = builder.y;
    }

    public static BarBuilder builder(Object[] x, double[] y) {
        return new BarBuilder(x, y);
    }

    public static BarBuilder builder(CategoricalColumn x, Column<? extends Number> y) {
        return new BarBuilder(x, y);
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        if (this.orientation == Orientation.HORIZONTAL) {
            context.put("x", Utils.dataAsString(this.y));
            context.put("y", Utils.dataAsString(this.x));
        } else {
            context.put("y", Utils.dataAsString(this.y));
            context.put("x", Utils.dataAsString(this.x));
        }
        context.put("orientation", this.orientation.value);
        return context;
    }

    public static class BarBuilder
    extends TraceBuilder {
        private final String type = "bar";
        final Object[] x;
        final double[] y;
        Orientation orientation = Orientation.VERTICAL;

        BarBuilder(Object[] x, double[] y) {
            this.x = x;
            this.y = y;
        }

        BarBuilder(CategoricalColumn x, Column<? extends Number> y) {
            this.x = TraceBuilder.columnToStringArray((Column)x);
            this.y = y.asDoubleArray();
        }

        public BarTrace build() {
            return new BarTrace(this);
        }

        public BarBuilder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public BarBuilder opacity(double opacity) {
            super.opacity(opacity);
            return this;
        }

        @Override
        public BarBuilder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public BarBuilder showLegend(boolean b) {
            super.showLegend(b);
            return this;
        }

        @Override
        protected String getType() {
            return "bar";
        }
    }

    public static enum Orientation {
        VERTICAL("v"),
        HORIZONTAL("h");

        final String value;

        private Orientation(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

