/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components.threeD;

import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.threeD.Camera;

public class Scene
extends Component {
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis zAxis;
    private final Camera camera;

    private Scene(SceneBuilder builder) {
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
        this.zAxis = builder.zAxis;
        this.camera = builder.camera;
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (this.xAxis != null) {
            context.put("xAxis", this.xAxis);
        }
        if (this.yAxis != null) {
            context.put("yAxis", this.yAxis);
        }
        if (this.zAxis != null) {
            context.put("zAxis", this.zAxis);
        }
        if (this.camera != null) {
            context.put("camera", this.camera);
        }
        return context;
    }

    public static SceneBuilder sceneBuilder() {
        return new SceneBuilder();
    }

    @Override
    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("scene_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    public static class SceneBuilder {
        private Axis xAxis;
        private Axis yAxis;
        private Axis zAxis;
        private Camera camera;

        public SceneBuilder xAxis(Axis axis) {
            this.xAxis = axis;
            return this;
        }

        public SceneBuilder yAxis(Axis axis) {
            this.yAxis = axis;
            return this;
        }

        public SceneBuilder zAxis(Axis axis) {
            this.zAxis = axis;
            return this;
        }

        public SceneBuilder camera(Camera camera) {
            this.camera = camera;
            return this;
        }

        public Scene build() {
            return new Scene(this);
        }
    }
}

