/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.error.PebbleException;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.Font;
import tech.tablesaw.plotly.components.Margin;
import tech.tablesaw.plotly.components.TemplateUtils;

public class Layout {
    private final PebbleEngine engine = TemplateUtils.getNewEngine();
    private Font font;
    private String title;
    private Font titleFont;
    private boolean autoSize;
    private int width;
    private int height;
    private Margin margin;
    private String paperBgColor;
    private String plotBgColor;
    private String decimalSeparator;
    private String thousandsSeparator;
    private boolean showLegend;
    private HoverMode hoverMode;
    private DragMode dragMode;
    private int hoverDistance;
    private Axis xAxis;
    private Axis yAxis;

    private Layout(LayoutBuilder builder) {
        this.title = builder.title;
        this.autoSize = builder.autoSize;
        this.decimalSeparator = builder.decimalSeparator;
        this.thousandsSeparator = builder.thousandsSeparator;
        this.dragMode = builder.dragMode;
        this.font = builder.font;
        this.titleFont = builder.titleFont;
        this.hoverDistance = builder.hoverDistance;
        this.hoverMode = builder.hoverMode;
        this.margin = builder.margin;
        this.height = builder.height;
        this.width = builder.width;
        this.xAxis = builder.xAxis;
        this.yAxis = builder.yAxis;
        this.paperBgColor = builder.paperBgColor;
        this.plotBgColor = builder.plotBgColor;
        this.showLegend = builder.showLegend;
    }

    public String asJavascript() {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("layout_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException | IOException e) {
            e.printStackTrace();
        }
        return ((Object)writer).toString();
    }

    protected Map<String, Object> getContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("title", this.title);
        context.put("titlefont", this.titleFont);
        context.put("width", this.width);
        context.put("height", this.height);
        context.put("font", this.font);
        context.put("autosize", this.autoSize);
        context.put("hoverdistance", this.hoverDistance);
        context.put("hoverMode", (Object)this.hoverMode);
        if (this.margin != null) {
            context.put("margin", this.margin);
        }
        context.put("dragmode", (Object)this.dragMode);
        context.put("showlegend", this.showLegend);
        context.put("plotbgcolor", this.plotBgColor);
        context.put("paperbgcolor", this.paperBgColor);
        if (this.xAxis != null) {
            context.put("xAxis", this.xAxis);
        }
        if (this.yAxis != null) {
            context.put("yAxis", this.yAxis);
        }
        return context;
    }

    public static LayoutBuilder builder() {
        return new LayoutBuilder();
    }

    public static class LayoutBuilder {
        Font font = Font.builder().build();
        String title = "";
        Font titleFont = this.font;
        boolean autoSize = false;
        int width = 700;
        int height = 450;
        Margin margin;
        String paperBgColor = "#fff";
        String plotBgColor = "#fff";
        String decimalSeparator = ".";
        String thousandsSeparator = ",";
        boolean showLegend = false;
        HoverMode hoverMode = HoverMode.FALSE;
        DragMode dragMode = DragMode.ZOOM;
        int hoverDistance = 20;
        Axis xAxis;
        Axis yAxis;

        public Layout build() {
            return new Layout(this);
        }

        private LayoutBuilder() {
        }

        public LayoutBuilder title(String title) {
            this.title = title;
            return this;
        }

        public LayoutBuilder titleFont(Font titleFont) {
            this.titleFont = titleFont;
            return this;
        }

        public LayoutBuilder margin(Margin margin) {
            this.margin = margin;
            return this;
        }

        public LayoutBuilder hoverMode(HoverMode hoverMode) {
            this.hoverMode = hoverMode;
            return this;
        }

        public LayoutBuilder hoverDistance(int distance) {
            this.hoverDistance = distance;
            return this;
        }

        public LayoutBuilder showLegend(boolean showLegend) {
            this.showLegend = showLegend;
            return this;
        }

        public LayoutBuilder height(int height) {
            this.height = height;
            return this;
        }

        public LayoutBuilder width(int width) {
            this.width = width;
            return this;
        }

        public LayoutBuilder xAxis(Axis axis) {
            this.xAxis = axis;
            return this;
        }

        public LayoutBuilder yAxis(Axis axis) {
            this.yAxis = axis;
            return this;
        }

        public LayoutBuilder plotBgColor(String color) {
            this.plotBgColor = color;
            return this;
        }

        public LayoutBuilder paperBgColor(String color) {
            this.paperBgColor = color;
            return this;
        }
    }

    public static enum DragMode {
        ZOOM("zoom"),
        PAN("pan"),
        SELECT("select"),
        LASSO("lasso"),
        ORBIT("orbit"),
        TURNTABLE("turntable");

        private String value;

        private DragMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum HoverMode {
        X("x"),
        Y("y"),
        CLOSEST("closest"),
        FALSE("false");

        private String value;

        private HoverMode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

