/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.JsonFlattener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.TableBuildingUtils;
import tech.tablesaw.io.json.JsonReadOptions;

public class JsonReader
implements DataReader<JsonReadOptions> {
    private static final JsonReader INSTANCE = new JsonReader();
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void register(ReaderRegistry registry) {
        registry.registerExtension("json", (DataReader)INSTANCE);
        registry.registerMimeType("application/json", (DataReader)INSTANCE);
        registry.registerOptions(JsonReadOptions.class, (DataReader)INSTANCE);
    }

    public Table read(JsonReadOptions options) throws IOException {
        JsonNode jsonObj = mapper.readTree(options.source().createReader(null));
        if (options.path() != null) {
            jsonObj = jsonObj.at(options.path());
        }
        if (!jsonObj.isArray()) {
            throw new IllegalStateException("Only reading a JSON array is currently supported. The array must hold an array or object for each row.");
        }
        if (jsonObj.size() == 0) {
            return Table.create((String)options.tableName());
        }
        JsonNode firstNode = jsonObj.get(0);
        if (firstNode.isArray()) {
            return this.convertArrayOfArrays(jsonObj, options);
        }
        return this.convertArrayOfObjects(jsonObj, options);
    }

    private Table convertArrayOfArrays(JsonNode jsonObj, ReadOptions options) {
        int i;
        JsonNode firstNode = jsonObj.get(0);
        boolean firstRowAllStrings = true;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (JsonNode n : firstNode) {
            if (n.isTextual()) continue;
            firstRowAllStrings = false;
        }
        boolean hasHeader = firstRowAllStrings;
        for (int i2 = 0; i2 < firstNode.size(); ++i2) {
            columnNames.add(hasHeader ? firstNode.get(i2).textValue() : "Column " + i2);
        }
        ArrayList<String[]> dataRows = new ArrayList<String[]>();
        int n = i = hasHeader ? 1 : 0;
        while (i < jsonObj.size()) {
            JsonNode arr = jsonObj.get(i);
            String[] row = new String[arr.size()];
            for (int j = 0; j < arr.size(); ++j) {
                row[j] = arr.get(j).asText();
            }
            dataRows.add(row);
            ++i;
        }
        return TableBuildingUtils.build(columnNames, dataRows, (ReadOptions)options);
    }

    private Table convertArrayOfObjects(JsonNode jsonObj, ReadOptions options) throws IOException {
        StringBuilder result = new StringBuilder("[");
        for (int i = 0; i < jsonObj.size(); ++i) {
            JsonNode rowObj = jsonObj.get(i);
            String flattenedRow = JsonFlattener.flatten((String)mapper.writeValueAsString((Object)rowObj));
            if (i != 0) {
                result.append(",");
            }
            result.append(flattenedRow);
        }
        String flattenedJsonString = result.append("]").toString();
        JsonNode flattenedJsonObj = mapper.readTree(flattenedJsonString);
        HashSet<String> colNames = new HashSet<String>();
        for (JsonNode row : flattenedJsonObj) {
            Iterator fieldNames = row.fieldNames();
            while (fieldNames.hasNext()) {
                colNames.add((String)fieldNames.next());
            }
        }
        ArrayList columnNames = new ArrayList(colNames);
        ArrayList<String[]> dataRows = new ArrayList<String[]>();
        for (JsonNode node : flattenedJsonObj) {
            String[] arr = new String[columnNames.size()];
            for (int i = 0; i < columnNames.size(); ++i) {
                arr[i] = node.has((String)columnNames.get(i)) ? node.get((String)columnNames.get(i)).asText() : null;
            }
            dataRows.add(arr);
        }
        return TableBuildingUtils.build(columnNames, dataRows, (ReadOptions)options);
    }

    public Table read(Source source) throws IOException {
        return this.read(JsonReadOptions.builder(source).build());
    }

    static {
        JsonReader.register(Table.defaultReaderRegistry);
    }
}

