/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.jsoup.nodes.Element;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriteOptions;

public class HtmlWriteOptions
extends WriteOptions {
    private final ElementCreator elementCreator;
    private final boolean escapeText;

    protected HtmlWriteOptions(Builder builder) {
        super((WriteOptions.Builder)builder);
        this.escapeText = builder.escapeText;
        this.elementCreator = builder.elementCreator;
    }

    public boolean escapeText() {
        return this.escapeText;
    }

    public ElementCreator elementCreator() {
        return this.elementCreator;
    }

    public static Builder builder(Destination dest) {
        return new Builder(dest);
    }

    public static Builder builder(OutputStream dest) {
        return new Builder(dest);
    }

    public static Builder builder(Writer dest) {
        return new Builder(dest);
    }

    public static Builder builder(File dest) throws IOException {
        return new Builder(dest);
    }

    public static Builder builder(String fileName) throws IOException {
        return HtmlWriteOptions.builder(new File(fileName));
    }

    public static interface ElementCreator {
        public Element create(String var1, Column<?> var2, Integer var3);

        default public Element create(String elementName) {
            return this.create(elementName, null, null);
        }
    }

    public static class Builder
    extends WriteOptions.Builder {
        private ElementCreator elementCreator = (elementName, column, row) -> new Element(elementName);
        private boolean escapeText = true;

        protected Builder(Destination dest) {
            super(dest);
        }

        protected Builder(File file) throws IOException {
            super(file);
        }

        public Builder escapeText(boolean escapeText) throws IOException {
            this.escapeText = escapeText;
            return this;
        }

        protected Builder(Writer writer) {
            super(writer);
        }

        protected Builder(OutputStream stream) {
            super(stream);
        }

        public Builder elementCreator(ElementCreator elementCreator) {
            this.elementCreator = elementCreator;
            return this;
        }

        public HtmlWriteOptions build() {
            return new HtmlWriteOptions(this);
        }
    }
}

