/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import tech.tablesaw.io.ReadOptions;

public class HtmlReadOptions
extends ReadOptions {
    protected HtmlReadOptions(Builder builder) {
        super((ReadOptions.Builder)builder);
    }

    public static Builder builder(File file) {
        return new Builder(file).tableName(file.getName());
    }

    public static Builder builder(String fileName) {
        return new Builder(new File(fileName));
    }

    public static Builder builder(InputStream stream, String tableName) {
        return new Builder(stream).tableName(tableName);
    }

    public static Builder builder(Reader reader, String tableName) {
        Builder builder = new Builder(reader);
        return builder.tableName(tableName);
    }

    public static class Builder
    extends ReadOptions.Builder {
        public Builder(File file) {
            super(file);
        }

        protected Builder(Reader reader) {
            super(reader);
        }

        protected Builder(InputStream stream) {
            super(stream);
        }

        public HtmlReadOptions build() {
            return new HtmlReadOptions(this);
        }

        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        public Builder tableName(String tableName) {
            super.tableName(tableName);
            return this;
        }

        public Builder sample(boolean sample) {
            super.sample(sample);
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        public Builder dateTimeFormat(String dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        public Builder locale(Locale locale) {
            super.locale(locale);
            return this;
        }

        public Builder missingValueIndicator(String missingValueIndicator) {
            super.missingValueIndicator(missingValueIndicator);
            return this;
        }

        public Builder minimizeColumnSizes(boolean minimizeColumnSizes) {
            super.minimizeColumnSizes(minimizeColumnSizes);
            return this;
        }
    }
}

