/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.xlsx;

import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.xlsx.XlsxWriteOptions;

public class XlsxWriter
implements DataWriter<XlsxWriteOptions> {
    private static final XlsxWriter INSTANCE = new XlsxWriter();

    public static void register(WriterRegistry registry) {
        registry.registerExtension("xlsx", (DataWriter)INSTANCE);
        registry.registerOptions(XlsxWriteOptions.class, (DataWriter)INSTANCE);
    }

    public void write(Table table, Destination dest) {
        this.write(table, XlsxWriteOptions.builder(dest).build());
    }

    public void write(Table table, XlsxWriteOptions options) {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            XSSFCellStyle localDateStyle = workbook.createCellStyle();
            localDateStyle.setDataFormat(workbook.createDataFormat().getFormat("yyyy-MM-dd"));
            XSSFCellStyle localDateTimeStyle = workbook.createCellStyle();
            localDateTimeStyle.setDataFormat(workbook.createDataFormat().getFormat("yyyy-MM-dd hh:mm:ss"));
            XSSFCellStyle localTimeStyle = workbook.createCellStyle();
            localTimeStyle.setDataFormat(workbook.createDataFormat().getFormat("[h]:mm:ss"));
            XSSFSheet sheet = workbook.createSheet(table.name());
            int rowNum = 0;
            List columnNames = table.columnNames();
            XSSFRow headerRow = sheet.createRow(rowNum++);
            int colNum = 0;
            for (String colName : columnNames) {
                XSSFCell cell = headerRow.createCell(colNum++);
                cell.setCellValue(colName);
            }
            for (Row row : table) {
                XSSFRow excelRow = sheet.createRow(rowNum++);
                colNum = 0;
                for (String colName : columnNames) {
                    XSSFCell cell = excelRow.createCell(colNum++);
                    ColumnType type = row.getColumnType(colName);
                    if (ColumnType.STRING.equals((Object)type)) {
                        cell.setCellValue(row.getString(colName));
                        continue;
                    }
                    if (ColumnType.LOCAL_DATE.equals((Object)type)) {
                        cell.setCellValue(row.getDate(colName));
                        cell.setCellStyle((CellStyle)localDateStyle);
                        continue;
                    }
                    if (ColumnType.LOCAL_DATE_TIME.equals((Object)type)) {
                        cell.setCellValue(row.getDate(colName));
                        cell.setCellStyle((CellStyle)localDateTimeStyle);
                        continue;
                    }
                    if (ColumnType.LOCAL_TIME.equals((Object)type)) {
                        double time = DateUtil.convertTime((String)row.getTime(colName).toString());
                        cell.setCellValue(time);
                        cell.setCellStyle((CellStyle)localTimeStyle);
                        continue;
                    }
                    if (ColumnType.INSTANT.equals((Object)type)) {
                        ZonedDateTime zdt = ZonedDateTime.ofInstant(row.getInstant(colName), ZoneId.systemDefault());
                        cell.setCellValue((Calendar)GregorianCalendar.from(zdt));
                        cell.setCellStyle((CellStyle)localDateTimeStyle);
                        continue;
                    }
                    if (ColumnType.FLOAT.equals((Object)type)) {
                        cell.setCellValue((double)row.getFloat(colName));
                        continue;
                    }
                    if (ColumnType.INTEGER.equals((Object)type)) {
                        cell.setCellValue((double)row.getInt(colName));
                        continue;
                    }
                    if (ColumnType.DOUBLE.equals((Object)type)) {
                        cell.setCellValue(row.getDouble(colName));
                        continue;
                    }
                    if (ColumnType.BOOLEAN.equals((Object)type)) {
                        cell.setCellValue(row.getBoolean(colName).booleanValue());
                        continue;
                    }
                    cell.setCellValue(String.valueOf(row.getObject(colName)));
                }
            }
            try (OutputStream os = options.destination().stream();){
                workbook.write(os);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    static {
        XlsxWriter.register(Table.defaultWriterRegistry);
    }
}

