/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.store;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.iq80.snappy.SnappyFramedInputStream;
import org.iq80.snappy.SnappyFramedOutputStream;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.store.TableMetadata;
import tech.tablesaw.table.Relation;

public class StorageManager {
    private static final int FLUSH_AFTER_ITERATIONS = 10000;
    private static final String FILE_EXTENSION = "saw";
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(StorageManager.separator()));
    private static final int READER_POOL_SIZE = 4;

    static String separator() {
        FileSystem fileSystem = FileSystems.getDefault();
        return fileSystem.getSeparator();
    }

    public static Table readTable(String path) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        ExecutorCompletionService<Void> readerCompletionService = new ExecutorCompletionService<Void>(executorService);
        TableMetadata tableMetadata = StorageManager.readTableMetadata(path + StorageManager.separator() + "Metadata.json");
        List<ColumnMetadata> columnMetadata = tableMetadata.getColumnMetadataList();
        Table table = Table.create(tableMetadata);
        ConcurrentLinkedQueue columnList = new ConcurrentLinkedQueue();
        HashMap<String, Column> columns = new HashMap<String, Column>();
        try {
            for (ColumnMetadata column : columnMetadata) {
                readerCompletionService.submit(() -> {
                    columnList.add(StorageManager.readColumn(path + StorageManager.separator() + column.getId(), column));
                    return null;
                });
            }
            for (int i = 0; i < columnMetadata.size(); ++i) {
                Future future = readerCompletionService.take();
                future.get();
            }
            for (Column c : columnList) {
                columns.put(c.id(), c);
            }
            for (ColumnMetadata metadata : columnMetadata) {
                String id = metadata.getId();
                table.addColumn((Column)columns.get(id));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        executorService.shutdown();
        return table;
    }

    private static Column readColumn(String fileName, ColumnMetadata columnMetadata) throws IOException {
        switch (columnMetadata.getType()) {
            case FLOAT: {
                return StorageManager.readFloatColumn(fileName, columnMetadata);
            }
            case INTEGER: {
                return StorageManager.readIntColumn(fileName, columnMetadata);
            }
            case BOOLEAN: {
                return StorageManager.readBooleanColumn(fileName, columnMetadata);
            }
            case LOCAL_DATE: {
                return StorageManager.readLocalDateColumn(fileName, columnMetadata);
            }
            case LOCAL_TIME: {
                return StorageManager.readLocalTimeColumn(fileName, columnMetadata);
            }
            case LOCAL_DATE_TIME: {
                return StorageManager.readLocalDateTimeColumn(fileName, columnMetadata);
            }
            case CATEGORY: {
                return StorageManager.readCategoryColumn(fileName, columnMetadata);
            }
            case SHORT_INT: {
                return StorageManager.readShortColumn(fileName, columnMetadata);
            }
            case LONG_INT: {
                return StorageManager.readLongColumn(fileName, columnMetadata);
            }
        }
        throw new RuntimeException("Unhandled column type writing columns");
    }

    private static FloatColumn readFloatColumn(String fileName, ColumnMetadata metadata) throws IOException {
        FloatColumn floats = new FloatColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    float cell = dis.readFloat();
                    floats.append(cell);
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return floats;
    }

    private static IntColumn readIntColumn(String fileName, ColumnMetadata metadata) throws IOException {
        IntColumn ints = new IntColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    ints.append(dis.readInt());
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return ints;
    }

    private static ShortColumn readShortColumn(String fileName, ColumnMetadata metadata) throws IOException {
        ShortColumn ints = new ShortColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    ints.append(dis.readShort());
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return ints;
    }

    private static LongColumn readLongColumn(String fileName, ColumnMetadata metadata) throws IOException {
        LongColumn ints = new LongColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    ints.append(dis.readLong());
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return ints;
    }

    private static DateColumn readLocalDateColumn(String fileName, ColumnMetadata metadata) throws IOException {
        DateColumn dates = new DateColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    int cell = dis.readInt();
                    dates.append(cell);
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return dates;
    }

    private static DateTimeColumn readLocalDateTimeColumn(String fileName, ColumnMetadata metadata) throws IOException {
        DateTimeColumn dates = new DateTimeColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    long cell = dis.readLong();
                    dates.append(cell);
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return dates;
    }

    private static TimeColumn readLocalTimeColumn(String fileName, ColumnMetadata metadata) throws IOException {
        TimeColumn times = new TimeColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    int cell = dis.readInt();
                    times.append(cell);
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return times;
    }

    static CategoryColumn readCategoryColumn(String fileName, ColumnMetadata metadata) throws IOException {
        CategoryColumn stringColumn = new CategoryColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            int stringCount = dis.readInt();
            for (int j = 0; j < stringCount; ++j) {
                stringColumn.dictionaryMap().put(j, dis.readUTF());
            }
            int size = metadata.getSize();
            for (int i = 0; i < size; ++i) {
                stringColumn.data().add(dis.readInt());
            }
        }
        return stringColumn;
    }

    private static BooleanColumn readBooleanColumn(String fileName, ColumnMetadata metadata) throws IOException {
        BooleanColumn bools = new BooleanColumn(metadata);
        try (FileInputStream fis = new FileInputStream(fileName);
             SnappyFramedInputStream sis = new SnappyFramedInputStream((InputStream)fis, true);
             DataInputStream dis = new DataInputStream((InputStream)sis);){
            boolean EOF = false;
            while (!EOF) {
                try {
                    boolean cell = dis.readBoolean();
                    bools.append(cell);
                }
                catch (EOFException e) {
                    EOF = true;
                }
            }
        }
        return bools;
    }

    public static String saveTable(String folderName, Relation table) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        ExecutorCompletionService<Void> writerCompletionService = new ExecutorCompletionService<Void>(executorService);
        String name = table.name();
        name = WHITE_SPACE_PATTERN.matcher(name).replaceAll("");
        name = SEPARATOR_PATTERN.matcher(name).replaceAll("_");
        String storageFolder = folderName + StorageManager.separator() + name + '.' + FILE_EXTENSION;
        Path path = Paths.get(storageFolder, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        StorageManager.writeTableMetadata(path.toString() + StorageManager.separator() + "Metadata.json", table);
        try {
            for (Column column : table.columns()) {
                writerCompletionService.submit(() -> {
                    Path columnPath = path.resolve(column.id());
                    StorageManager.writeColumn(columnPath.toString(), column);
                    return null;
                });
            }
            for (int i = 0; i < table.columnCount(); ++i) {
                Future future = writerCompletionService.take();
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        executorService.shutdown();
        return storageFolder;
    }

    private static void writeColumn(String fileName, Column column) {
        try {
            switch (column.type()) {
                case FLOAT: {
                    StorageManager.writeColumn(fileName, (FloatColumn)column);
                    break;
                }
                case DOUBLE: {
                    StorageManager.writeColumn(fileName, (DoubleColumn)column);
                    break;
                }
                case INTEGER: {
                    StorageManager.writeColumn(fileName, (IntColumn)column);
                    break;
                }
                case BOOLEAN: {
                    StorageManager.writeColumn(fileName, (BooleanColumn)column);
                    break;
                }
                case LOCAL_DATE: {
                    StorageManager.writeColumn(fileName, (DateColumn)column);
                    break;
                }
                case LOCAL_TIME: {
                    StorageManager.writeColumn(fileName, (TimeColumn)column);
                    break;
                }
                case LOCAL_DATE_TIME: {
                    StorageManager.writeColumn(fileName, (DateTimeColumn)column);
                    break;
                }
                case CATEGORY: {
                    StorageManager.writeColumn(fileName, (CategoryColumn)column);
                    break;
                }
                case SHORT_INT: {
                    StorageManager.writeColumn(fileName, (ShortColumn)column);
                    break;
                }
                case LONG_INT: {
                    StorageManager.writeColumn(fileName, (LongColumn)column);
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled column type writing columns");
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException writing to file");
        }
    }

    @VisibleForTesting
    static void writeColumn(String fileName, FloatColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            FloatIterator floatIterator = column.iterator();
            while (floatIterator.hasNext()) {
                float d = ((Float)floatIterator.next()).floatValue();
                dos.writeFloat(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, DoubleColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            DoubleIterator doubleIterator = column.iterator();
            while (doubleIterator.hasNext()) {
                double d = (Double)doubleIterator.next();
                dos.writeDouble(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, CategoryColumn column) throws IOException {
        int categoryCount = column.dictionaryMap().size();
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            dos.writeInt(categoryCount);
            TreeSet keys = new TreeSet(column.dictionaryMap().keyToValueMap().keySet());
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                int key = (Integer)iterator.next();
                dos.writeUTF(column.dictionaryMap().get(key));
            }
            dos.flush();
            int i = 0;
            IntListIterator intListIterator = column.data().iterator();
            while (intListIterator.hasNext()) {
                int d = (Integer)intListIterator.next();
                dos.writeInt(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
        }
    }

    static void writeColumn(String fileName, IntColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            IntListIterator intListIterator = column.data().iterator();
            while (intListIterator.hasNext()) {
                int d = (Integer)intListIterator.next();
                dos.writeInt(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, ShortColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            ShortIterator shortIterator = column.iterator();
            while (shortIterator.hasNext()) {
                short d = (Short)shortIterator.next();
                dos.writeShort(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, LongColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            LongIterator longIterator = column.iterator();
            while (longIterator.hasNext()) {
                long d = (Long)longIterator.next();
                dos.writeLong(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, DateColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            IntListIterator intListIterator = column.data().iterator();
            while (intListIterator.hasNext()) {
                int d = (Integer)intListIterator.next();
                dos.writeInt(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, DateTimeColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            LongListIterator longListIterator = column.data().iterator();
            while (longListIterator.hasNext()) {
                long d = (Long)longListIterator.next();
                dos.writeLong(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, TimeColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            int i = 0;
            IntListIterator intListIterator = column.data().iterator();
            while (intListIterator.hasNext()) {
                int d = (Integer)intListIterator.next();
                dos.writeInt(d);
                if (i % 10000 == 0) {
                    dos.flush();
                }
                ++i;
            }
            dos.flush();
        }
    }

    static void writeColumn(String fileName, BooleanColumn column) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fileName);
             SnappyFramedOutputStream sos = new SnappyFramedOutputStream((OutputStream)fos);
             DataOutputStream dos = new DataOutputStream((OutputStream)sos);){
            for (int i = 0; i < column.size(); ++i) {
                boolean value = column.get(i);
                dos.writeBoolean(value);
                if (i % 10000 != 0) continue;
                dos.flush();
            }
            dos.flush();
        }
    }

    private static void writeTableMetadata(String fileName, Relation table) throws IOException {
        File myFile = Paths.get(fileName, new String[0]).toFile();
        myFile.createNewFile();
        try (FileOutputStream fOut = new FileOutputStream(myFile);
             OutputStreamWriter myOutWriter = new OutputStreamWriter(fOut);){
            myOutWriter.append(new TableMetadata(table).toJson());
        }
    }

    private static TableMetadata readTableMetadata(String fileName) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(fileName, new String[0]));
        return TableMetadata.fromJson(new String(encoded, StandardCharsets.UTF_8));
    }
}

