/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.ml.regression;

import com.google.common.base.Strings;
import smile.regression.OLS;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.util.DoubleArrays;

public class LeastSquares {
    private final OLS model;
    private final double[][] explanatoryVariables;
    private final int explanatoryVariableCount;
    private final double[] responseVarArray;
    private final String[] explanatoryVariableNames;

    public LeastSquares(NumericColumn responseVariable, NumericColumn ... explanatoryVars) {
        this.explanatoryVariables = DoubleArrays.to2dArray(explanatoryVars);
        this.responseVarArray = responseVariable.toDoubleArray();
        this.model = new OLS(this.explanatoryVariables, this.responseVarArray);
        this.explanatoryVariableCount = explanatoryVars.length;
        this.explanatoryVariableNames = new String[this.explanatoryVariableCount];
        for (int i = 0; i < this.explanatoryVariableCount; ++i) {
            this.explanatoryVariableNames[i] = explanatoryVars[i].name();
        }
    }

    public static LeastSquares train(NumericColumn responseVar, NumericColumn ... explanatoryVars) {
        return new LeastSquares(responseVar, explanatoryVars);
    }

    public String toString() {
        String result = this.model.toString();
        result = result.replace("Intercept", "(Intercept)");
        int maxNameLength = "(intercept)".length() - 1;
        for (int i = 0; i < this.explanatoryVariableCount; ++i) {
            String replacement = this.explanatoryVariableNames[i];
            replacement = replacement.length() >= maxNameLength ? replacement.substring(0, maxNameLength) : Strings.padEnd((String)replacement, (int)maxNameLength, (char)' ');
            result = result.replaceFirst("Var " + (i + 1) + '\t', replacement);
        }
        return result;
    }

    public double[] residuals() {
        return this.model.residuals();
    }

    public double[] fitted() {
        double[] fitted = new double[this.explanatoryVariables.length];
        for (int i = 0; i < this.explanatoryVariables.length; ++i) {
            double[] input = this.explanatoryVariables[i];
            fitted[i] = this.predict(input);
        }
        return fitted;
    }

    public double adjustedRSquared() {
        return this.model.adjustedRSquared();
    }

    public double df() {
        return this.model.df();
    }

    public double error() {
        return this.model.error();
    }

    public double ftest() {
        return this.model.ftest();
    }

    public double pValue() {
        return this.model.pvalue();
    }

    public double intercept() {
        return this.model.intercept();
    }

    public double RSquared() {
        return this.model.RSquared();
    }

    public double RSS() {
        return this.model.RSS();
    }

    public double[][] ttest() {
        return this.model.ttest();
    }

    public double predict(double[] x) {
        return this.model.predict(x);
    }

    public double[] coefficients() {
        return this.model.coefficients();
    }

    public double[] actuals() {
        return this.responseVarArray;
    }
}

