/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.ml.association;

import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortRBTreeSet;
import java.util.List;
import smile.association.FPGrowth;
import smile.association.ItemSet;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.table.ViewGroup;

public class FrequentItemset {
    private final FPGrowth model;
    private final int setCount;

    public FrequentItemset(IntColumn sets, IntColumn items, double supportThreshold) {
        Table temp = Table.create("temp");
        temp.addColumn(sets.copy());
        temp.addColumn(items.copy());
        temp.sortAscendingOn(sets.name(), items.name());
        ViewGroup baskets = temp.splitOn(temp.column(0));
        this.setCount = baskets.size();
        int[][] itemsets = new int[this.setCount][];
        int basketIndex = 0;
        for (TemporaryView basket : baskets) {
            IntRBTreeSet set = new IntRBTreeSet((IntCollection)basket.intColumn(1).data());
            int itemIndex = 0;
            itemsets[basketIndex] = new int[set.size()];
            IntBidirectionalIterator intBidirectionalIterator = set.iterator();
            while (intBidirectionalIterator.hasNext()) {
                int item;
                itemsets[basketIndex][itemIndex] = item = ((Integer)intBidirectionalIterator.next()).intValue();
                ++itemIndex;
            }
            ++basketIndex;
        }
        this.model = new FPGrowth((int[][])itemsets, supportThreshold);
    }

    public FrequentItemset(IntColumn sets, CategoryColumn items, double support) {
        Table temp = Table.create("temp");
        temp.addColumn(sets.copy());
        IntColumn encodedItems = items.toIntColumn();
        encodedItems.setName(items.name());
        temp.addColumn(encodedItems);
        temp.sortAscendingOn(sets.name(), items.name());
        ViewGroup baskets = temp.splitOn(temp.column(0));
        this.setCount = baskets.size();
        int[][] itemsets = new int[this.setCount][];
        int basketIndex = 0;
        for (TemporaryView basket : baskets) {
            IntRBTreeSet set = new IntRBTreeSet((IntCollection)basket.intColumn(1).data());
            int itemIndex = 0;
            itemsets[basketIndex] = new int[set.size()];
            IntBidirectionalIterator intBidirectionalIterator = set.iterator();
            while (intBidirectionalIterator.hasNext()) {
                int item;
                itemsets[basketIndex][itemIndex] = item = ((Integer)intBidirectionalIterator.next()).intValue();
                ++itemIndex;
            }
            ++basketIndex;
        }
        this.model = new FPGrowth((int[][])itemsets, support);
    }

    public FrequentItemset(ShortColumn sets, CategoryColumn items, double support) {
        Table temp = Table.create("temp");
        temp.addColumn(sets.copy());
        IntColumn encodedItems = items.toIntColumn();
        encodedItems.setName(items.name());
        temp.addColumn(encodedItems);
        temp.sortAscendingOn(sets.name(), items.name());
        ViewGroup baskets = temp.splitOn(temp.column(0));
        this.setCount = baskets.size();
        int[][] itemsets = new int[this.setCount][];
        int basketIndex = 0;
        for (TemporaryView basket : baskets) {
            IntRBTreeSet set = new IntRBTreeSet((IntCollection)basket.intColumn(1).data());
            int itemIndex = 0;
            itemsets[basketIndex] = new int[set.size()];
            IntBidirectionalIterator intBidirectionalIterator = set.iterator();
            while (intBidirectionalIterator.hasNext()) {
                int item;
                itemsets[basketIndex][itemIndex] = item = ((Integer)intBidirectionalIterator.next()).intValue();
                ++itemIndex;
            }
            ++basketIndex;
        }
        this.model = new FPGrowth((int[][])itemsets, support);
    }

    public FrequentItemset(ShortColumn sets, ShortColumn items, double support) {
        Table temp = Table.create("temp");
        temp.addColumn(sets.copy());
        temp.addColumn(items.copy());
        temp.sortAscendingOn(sets.name(), items.name());
        ViewGroup baskets = temp.splitOn(temp.column(0));
        this.setCount = baskets.size();
        int[][] itemsets = new int[this.setCount][];
        int basketIndex = 0;
        for (TemporaryView basket : baskets) {
            ShortRBTreeSet set = new ShortRBTreeSet((ShortCollection)basket.shortColumn(1).data());
            int itemIndex = 0;
            itemsets[basketIndex] = new int[set.size()];
            ShortBidirectionalIterator shortBidirectionalIterator = set.iterator();
            while (shortBidirectionalIterator.hasNext()) {
                short item = (Short)shortBidirectionalIterator.next();
                itemsets[basketIndex][itemIndex] = item;
                ++itemIndex;
            }
            ++basketIndex;
        }
        this.model = new FPGrowth((int[][])itemsets, support);
    }

    public List<ItemSet> learn() {
        return this.model.learn();
    }

    public Object2IntOpenHashMap<int[]> supportMap() {
        List<ItemSet> itemSets = this.learn();
        Object2IntOpenHashMap confidenceMap = new Object2IntOpenHashMap(itemSets.size());
        for (ItemSet itemSet : itemSets) {
            confidenceMap.put((Object)itemSet.items, itemSet.support);
        }
        return confidenceMap;
    }

    public Object2DoubleOpenHashMap<int[]> supportMap(int supportThreshold) {
        List<ItemSet> itemSets = this.learn();
        Object2DoubleOpenHashMap supportMap = new Object2DoubleOpenHashMap(itemSets.size());
        for (ItemSet itemSet : itemSets) {
            if (itemSet.support < supportThreshold) continue;
            supportMap.put((Object)itemSet.items, (double)itemSet.support);
        }
        return supportMap;
    }

    public Object2DoubleOpenHashMap<IntRBTreeSet> confidenceMap() {
        List<ItemSet> itemSets = this.learn();
        Object2DoubleOpenHashMap confidenceMap = new Object2DoubleOpenHashMap(itemSets.size());
        for (ItemSet itemSet : itemSets) {
            IntRBTreeSet itemSetCopy = new IntRBTreeSet(itemSet.items);
            confidenceMap.put((Object)itemSetCopy, (double)itemSet.support / (double)this.setCount);
        }
        return confidenceMap;
    }

    public Object2DoubleOpenHashMap<IntRBTreeSet> confidenceMap(double supportThreshold) {
        List<ItemSet> itemSets = this.learn();
        Object2DoubleOpenHashMap confidenceMap = new Object2DoubleOpenHashMap(itemSets.size());
        long intSupportThreshold = Math.round((double)itemSets.size() * supportThreshold);
        for (ItemSet itemSet : itemSets) {
            if ((long)itemSet.support < intSupportThreshold) continue;
            IntRBTreeSet itemSetCopy = new IntRBTreeSet(itemSet.items);
            confidenceMap.put((Object)itemSetCopy, (double)itemSet.support / (double)this.setCount);
        }
        return confidenceMap;
    }
}

