/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.reducing.NumericReduceFunction;
import tech.tablesaw.reducing.NumericSummaryTable;
import tech.tablesaw.table.TemporaryView;
import tech.tablesaw.util.BitmapBackedSelection;

public class ViewGroup
implements Iterable<TemporaryView> {
    private static final String SPLIT_STRING = "~~~";
    private static final Splitter SPLITTER = Splitter.on((String)"~~~");
    private final Table sortedOriginal;
    private List<TemporaryView> subTables = new ArrayList<TemporaryView>();
    private String[] splitColumnNames;

    public ViewGroup(Table original, Column ... columns) {
        this.splitColumnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            this.splitColumnNames[i] = columns[i].name();
        }
        this.sortedOriginal = original.sortOn(this.splitColumnNames);
        this.splitOn(this.splitColumnNames);
    }

    public static ViewGroup create(Table original, String ... columnsNames) {
        List<Column> columns = original.columns(columnsNames);
        return new ViewGroup(original, columns.toArray(new Column[columns.size()]));
    }

    private void splitOn(String ... columnNames) {
        TemporaryView view;
        List<Column> columns = this.sortedOriginal.columns(columnNames);
        int byteSize = this.getByteSize(columns);
        byte[] currentKey = null;
        String currentStringKey = null;
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int row = 0; row < this.sortedOriginal.rowCount(); ++row) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byteSize);
            String newStringKey = "";
            for (int col = 0; col < columnNames.length; ++col) {
                if (col > 0) {
                    newStringKey = newStringKey + SPLIT_STRING;
                }
                Column c = this.sortedOriginal.column(columnNames[col]);
                String groupKey = this.sortedOriginal.get(row, this.sortedOriginal.columnIndex(c));
                newStringKey = newStringKey + groupKey;
                byteBuffer.put(c.asBytes(row));
            }
            byte[] newKey = byteBuffer.array();
            if (row == 0) {
                currentKey = newKey;
                currentStringKey = newStringKey;
            }
            if (!Arrays.equals(newKey, currentKey)) {
                currentKey = newKey;
                view = new TemporaryView(this.sortedOriginal, selection);
                view.setName(currentStringKey);
                currentStringKey = newStringKey;
                this.addViewToSubTables(view);
                selection = new BitmapBackedSelection();
                selection.add(row);
                continue;
            }
            selection.add(row);
        }
        if (!selection.isEmpty()) {
            view = new TemporaryView(this.sortedOriginal, selection);
            view.setName(currentStringKey);
            this.addViewToSubTables(view);
        }
    }

    private int getByteSize(List<Column> columns) {
        int byteSize = 0;
        for (Column c : columns) {
            byteSize += c.byteSize();
        }
        return byteSize;
    }

    private void addViewToSubTables(TemporaryView view) {
        this.subTables.add(view);
    }

    public List<TemporaryView> getSubTables() {
        return this.subTables;
    }

    public TemporaryView get(int i) {
        return this.subTables.get(i);
    }

    @VisibleForTesting
    public Table getSortedOriginal() {
        return this.sortedOriginal;
    }

    public int size() {
        return this.subTables.size();
    }

    private NumericSummaryTable splitGroupingColumn(NumericSummaryTable groupTable) {
        ArrayList<Column> newColumns = new ArrayList<Column>();
        List<Column> columns = this.sortedOriginal.columns(this.splitColumnNames);
        for (Column column : columns) {
            Column newColumn = column.emptyCopy();
            newColumns.add(newColumn);
        }
        for (int row = 0; row < groupTable.rowCount(); ++row) {
            List strings = SPLITTER.splitToList((CharSequence)groupTable.categoryColumn("Group").get(row));
            for (int col = 0; col < newColumns.size(); ++col) {
                ((Column)newColumns.get(col)).appendCell((String)strings.get(col));
            }
        }
        for (int col = 0; col < newColumns.size(); ++col) {
            Column c = (Column)newColumns.get(col);
            groupTable.addColumn(col, c);
        }
        groupTable.removeColumns("Group");
        return groupTable;
    }

    public NumericSummaryTable reduce(String numericColumnName, NumericReduceFunction function) {
        Preconditions.checkArgument((!this.subTables.isEmpty() ? 1 : 0) != 0);
        NumericSummaryTable groupTable = NumericSummaryTable.create(this.sortedOriginal.name() + " summary");
        CategoryColumn groupColumn = new CategoryColumn("Group", this.subTables.size());
        FloatColumn resultColumn = new FloatColumn(this.reduceColumnName(numericColumnName, function.functionName()), this.subTables.size());
        groupTable.addColumn(groupColumn);
        groupTable.addColumn(resultColumn);
        for (TemporaryView subTable : this.subTables) {
            double result = subTable.reduce(numericColumnName, function);
            groupColumn.add(subTable.name());
            resultColumn.append((float)result);
        }
        return this.splitGroupingColumn(groupTable);
    }

    @Override
    public Iterator<TemporaryView> iterator() {
        return this.subTables.iterator();
    }

    private String reduceColumnName(String columnName, String functionName) {
        return String.format("%s [%s]", functionName, columnName);
    }
}

