/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.reducing.NumericReduceFunction;
import tech.tablesaw.table.Relation;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.Selection;

public class TemporaryView
extends Relation
implements IntIterable {
    private final Selection rowMap;
    private String name;
    private Table table;

    public TemporaryView(Table table, Selection rowSelection) {
        this.name = table.name();
        this.rowMap = rowSelection;
        this.table = table;
    }

    @Override
    public Column column(int columnIndex) {
        return this.table.column(columnIndex);
    }

    @Override
    public int columnCount() {
        return this.table.columnCount();
    }

    @Override
    public int rowCount() {
        return this.rowMap.size();
    }

    @Override
    public List<Column> columns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 0; i < this.columnCount(); ++i) {
            columns.add(this.column(i));
        }
        return columns;
    }

    @Override
    public int columnIndex(Column column) {
        return this.table.columnIndex(column);
    }

    @Override
    public String get(int r, int c) {
        return this.table.get(r, c);
    }

    @Override
    public void addColumn(Column ... column) {
        throw new UnsupportedOperationException("TemporaryView does not support the addColumn operation");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void clear() {
        this.rowMap.clear();
    }

    @Override
    public List<String> columnNames() {
        return this.table.columnNames();
    }

    @Override
    public void removeColumns(Column ... columns) {
        throw new UnsupportedOperationException("TemporaryView does not support the removeColumns operation");
    }

    @Override
    public Table first(int nRows) {
        BitmapBackedSelection newMap = new BitmapBackedSelection();
        IntIterator it = this.intIterator();
        for (int count = 0; it.hasNext() && count < nRows; ++count) {
            int row = it.nextInt();
            newMap.add(row);
        }
        return this.table.selectWhere(newMap);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String print() {
        StringBuilder buf = new StringBuilder();
        int[] colWidths = this.colWidths();
        buf.append(this.name()).append('\n');
        List<String> names = this.columnNames();
        for (int colNum = 0; colNum < this.columnCount(); ++colNum) {
            buf.append(StringUtils.rightPad((String)StringUtils.defaultString((String)String.valueOf(names.get(colNum))), (int)colWidths[colNum]));
            buf.append(' ');
        }
        buf.append('\n');
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int r = iterator.nextInt();
            for (int i = 0; i < this.columnCount(); ++i) {
                String cell = StringUtils.rightPad((String)this.get(i, r), (int)colWidths[i]);
                buf.append(cell);
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public int[] colWidths() {
        int cols = this.columnCount();
        int[] widths = new int[cols];
        List<String> columnNames = this.columnNames();
        for (int i = 0; i < this.columnCount(); ++i) {
            widths[i] = columnNames.get(i).length();
        }
        for (int rowNum = 0; rowNum < this.rowCount(); ++rowNum) {
            for (int colNum = 0; colNum < cols; ++colNum) {
                String value = this.get(colNum, rowNum);
                widths[colNum] = Math.max(widths[colNum], StringUtils.length((CharSequence)value));
            }
        }
        return widths;
    }

    public Table asTable() {
        Table table = Table.create(this.name());
        for (Column column : this.columns()) {
            table.addColumn(column.subset(this.rowMap));
        }
        return table;
    }

    IntIterator intIterator() {
        return this.rowMap.iterator();
    }

    public double reduce(String numericColumnName, NumericReduceFunction function) {
        Column column = this.column(numericColumnName);
        return function.reduce(column.subset(this.rowMap).toDoubleArray());
    }

    @Override
    public BooleanColumn booleanColumn(int columnIndex) {
        return (BooleanColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public BooleanColumn booleanColumn(String columnName) {
        return (BooleanColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public FloatColumn floatColumn(int columnIndex) {
        return (FloatColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public FloatColumn floatColumn(String columnName) {
        return (FloatColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public IntColumn intColumn(String columnName) {
        return (IntColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public IntColumn intColumn(int columnIndex) {
        return (IntColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public ShortColumn shortColumn(String columnName) {
        return (ShortColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public ShortColumn shortColumn(int columnIndex) {
        return (ShortColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public LongColumn longColumn(String columnName) {
        return (LongColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public LongColumn longColumn(int columnIndex) {
        return (LongColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public DateColumn dateColumn(int columnIndex) {
        return (DateColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public DateColumn dateColumn(String columnName) {
        return (DateColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public TimeColumn timeColumn(String columnName) {
        return (TimeColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public TimeColumn timeColumn(int columnIndex) {
        return (TimeColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public DateTimeColumn dateTimeColumn(int columnIndex) {
        return (DateTimeColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public DateTimeColumn dateTimeColumn(String columnName) {
        return (DateTimeColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public CategoryColumn categoryColumn(String columnName) {
        return (CategoryColumn)this.column(columnName).subset(this.rowMap);
    }

    @Override
    public CategoryColumn categoryColumn(int columnIndex) {
        return (CategoryColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public NumericColumn numericColumn(int columnIndex) {
        return (NumericColumn)this.column(columnIndex).subset(this.rowMap);
    }

    @Override
    public NumericColumn numericColumn(String columnName) {
        return (NumericColumn)this.column(columnName).subset(this.rowMap);
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int i = 0;

            public int nextInt() {
                return this.i++;
            }

            public int skip(int k) {
                return this.i + k;
            }

            public boolean hasNext() {
                return this.i < TemporaryView.this.rowCount();
            }

            public Integer next() {
                return this.i++;
            }
        };
    }
}

